/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.jms;

import com.thoughtworks.xstream.XStream;
import java.util.Date;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.audit.event.LogEvent;
import org.drools.audit.event.RuleFlowLogEvent;
import org.drools.audit.event.RuleFlowNodeLogEvent;
import org.drools.audit.event.RuleFlowVariableLogEvent;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.event.ExtendedRuleFlowLogEvent;

public class AsyncAuditLogReceiver
implements MessageListener {
    private EntityManagerFactory entityManagerFactory;

    public AsyncAuditLogReceiver(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            EntityManager em = this.getEntityManager();
            TextMessage textMessage = (TextMessage)message;
            try {
                String messageContent = textMessage.getText();
                XStream xstram = new XStream();
                LogEvent event = (LogEvent)xstram.fromXML(messageContent);
                switch (event.getType()) {
                    case 8: {
                        RuleFlowLogEvent processCreatedEvent = (RuleFlowLogEvent)event;
                        ProcessInstanceLog logProcessCreated = new ProcessInstanceLog(processCreatedEvent.getProcessInstanceId(), processCreatedEvent.getProcessId());
                        if (processCreatedEvent instanceof ExtendedRuleFlowLogEvent) {
                            logProcessCreated.setParentProcessInstanceId(((ExtendedRuleFlowLogEvent)processCreatedEvent).getParentProcessInstanceId());
                        }
                        em.persist((Object)logProcessCreated);
                        break;
                    }
                    case 11: {
                        RuleFlowLogEvent processCompletedEvent = (RuleFlowLogEvent)event;
                        List result = em.createQuery("from ProcessInstanceLog as log where log.processInstanceId = ? and log.end is null").setParameter(1, (Object)processCompletedEvent.getProcessInstanceId()).getResultList();
                        if (result == null || result.size() == 0) break;
                        ProcessInstanceLog log = (ProcessInstanceLog)result.get(result.size() - 1);
                        log.setEnd(new Date());
                        if (processCompletedEvent instanceof ExtendedRuleFlowLogEvent) {
                            log.setStatus(((ExtendedRuleFlowLogEvent)processCompletedEvent).getProcessInstanceState());
                            log.setOutcome(((ExtendedRuleFlowLogEvent)processCompletedEvent).getOutcome());
                        }
                        em.merge((Object)log);
                        break;
                    }
                    case 24: {
                        RuleFlowNodeLogEvent nodeEnteredEvent = (RuleFlowNodeLogEvent)event;
                        NodeInstanceLog logNodeEnter = new NodeInstanceLog(0, nodeEnteredEvent.getProcessInstanceId(), nodeEnteredEvent.getProcessId(), nodeEnteredEvent.getNodeInstanceId(), nodeEnteredEvent.getNodeId(), nodeEnteredEvent.getNodeName());
                        em.persist((Object)logNodeEnter);
                        break;
                    }
                    case 26: {
                        RuleFlowNodeLogEvent nodeExitedEvent = (RuleFlowNodeLogEvent)event;
                        NodeInstanceLog logNodeExit = new NodeInstanceLog(1, nodeExitedEvent.getProcessInstanceId(), nodeExitedEvent.getProcessId(), nodeExitedEvent.getNodeInstanceId(), nodeExitedEvent.getNodeId(), nodeExitedEvent.getNodeName());
                        em.persist((Object)logNodeExit);
                        break;
                    }
                    case 33: {
                        RuleFlowVariableLogEvent variableEvent = (RuleFlowVariableLogEvent)event;
                        VariableInstanceLog logVariable = new VariableInstanceLog(variableEvent.getProcessInstanceId(), variableEvent.getProcessId(), variableEvent.getVariableInstanceId(), variableEvent.getVariableId(), variableEvent.getObjectToString());
                        em.persist((Object)logVariable);
                        break;
                    }
                }
                em.flush();
                em.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
                throw new RuntimeException("Exception when receiving audit event event", e);
            }
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManager getEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }
}

