/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

public class ServiceTaskHandler
implements WorkItemHandler {
    private boolean logThrownException = true;

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        String service = (String)workItem.getParameter("Interface");
        String operation = (String)workItem.getParameter("Operation");
        String parameterType = (String)workItem.getParameter("ParameterType");
        Object parameter = workItem.getParameter("Parameter");
        try {
            Class<?> c = Class.forName(service);
            Object instance = c.newInstance();
            Class[] classes = null;
            Object[] params = null;
            if (parameterType != null) {
                classes = new Class[]{Class.forName(parameterType)};
                params = new Object[]{parameter};
            }
            Method method = c.getMethod(operation, classes);
            Object result = method.invoke(instance, params);
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put("Result", result);
            manager.completeWorkItem(workItem.getId(), results);
        }
        catch (ClassNotFoundException cnfe) {
            this.handleException(cnfe, service, operation, parameterType, parameter);
        }
        catch (InstantiationException ie) {
            this.handleException(ie, service, operation, parameterType, parameter);
        }
        catch (IllegalAccessException iae) {
            this.handleException(iae, service, operation, parameterType, parameter);
        }
        catch (NoSuchMethodException nsme) {
            this.handleException(nsme, service, operation, parameterType, parameter);
        }
        catch (InvocationTargetException ite) {
            this.handleException(ite, service, operation, parameterType, parameter);
        }
        catch (Throwable cause) {
            this.handleException(cause, service, operation, parameterType, parameter);
        }
    }

    private void handleException(Throwable cause, String service, String operation, String paramType, Object param) {
        if (!this.logThrownException) {
            WorkItemHandlerRuntimeException wihRe;
            if (cause instanceof InvocationTargetException) {
                Throwable realCause = cause.getCause();
                wihRe = new WorkItemHandlerRuntimeException(realCause);
                wihRe.setStackTrace(realCause.getStackTrace());
            } else {
                wihRe = new WorkItemHandlerRuntimeException(cause);
                wihRe.setStackTrace(cause.getStackTrace());
            }
            wihRe.setInformation("Interface", service);
            wihRe.setInformation("Operation", operation);
            wihRe.setInformation("ParameterType", paramType);
            wihRe.setInformation("Parameter", param);
            wihRe.setInformation("workItemHandlerType", this.getClass().getSimpleName());
            throw wihRe;
        }
        String message = this.getClass().getSimpleName() + " failed when calling " + service + "." + operation;
        System.err.println(message);
        cause.printStackTrace(System.err);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }

    public void setLogThrownException(boolean logException) {
        this.logThrownException = logException;
    }
}

