/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieContainer;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.util.CDIHelper;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.utils.CompositeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieContainerImpl
implements InternalKieContainer {
    private static final Logger log = LoggerFactory.getLogger(KieContainerImpl.class);
    private KieProject kProject;
    private final Map<String, KieBase> kBases = new HashMap<String, KieBase>();
    private final Map<String, KieSession> kSessions = new HashMap<String, KieSession>();
    private final Map<String, StatelessKieSession> statelessKSessions = new HashMap<String, StatelessKieSession>();
    private final KieRepository kr;

    public KieContainerImpl(KieProject kProject, KieRepository kr) {
        this.kr = kr;
        this.kProject = kProject;
        kProject.init();
    }

    public ReleaseId getReleaseId() {
        return this.kProject.getGAV();
    }

    public void updateToVersion(ReleaseId releaseId) {
        this.kBases.clear();
        this.kProject = new KieModuleKieProject((InternalKieModule)this.kr.getKieModule(releaseId), this.kr);
        this.kProject.init();
    }

    public KieBase getKieBase() {
        KieBaseModel defaultKieBaseModel = this.kProject.getDefaultKieBaseModel();
        if (defaultKieBaseModel == null) {
            throw new RuntimeException("Cannot find a defualt KieBase");
        }
        return this.getKieBase(defaultKieBaseModel.getName());
    }

    public Results verify() {
        return this.kProject.verify();
    }

    public KieBase getKieBase(String kBaseName) {
        KieBase kBase = this.kBases.get(kBaseName);
        if (kBase == null) {
            ResultsImpl msgs = new ResultsImpl();
            kBase = this.createKieBase(kBaseName, this.kProject, msgs, null);
            if (kBase == null) {
                throw new RuntimeException("Error while creating KieBase" + msgs.filterMessages(Message.Level.ERROR));
            }
            if (kBase != null) {
                this.kBases.put(kBaseName, kBase);
            }
        }
        return kBase;
    }

    public KieBase newKieBase(KieBaseConfiguration conf) {
        KieBaseModel defaultKieBaseModel = this.kProject.getDefaultKieBaseModel();
        if (defaultKieBaseModel == null) {
            throw new RuntimeException("Cannot find a defualt KieBase");
        }
        return this.newKieBase(defaultKieBaseModel.getName(), conf);
    }

    public KieBase newKieBase(String kBaseName, KieBaseConfiguration conf) {
        ResultsImpl msgs = new ResultsImpl();
        KieBase kBase = this.createKieBase(kBaseName, this.kProject, msgs, conf);
        if (kBase == null) {
            throw new RuntimeException("Error while creating KieBase" + msgs.filterMessages(Message.Level.ERROR));
        }
        return kBase;
    }

    private KieBase createKieBase(String kBaseName, KieProject kieProject, ResultsImpl messages, KieBaseConfiguration conf) {
        KnowledgeBuilder kbuilder;
        KieBaseModelImpl kBaseModel = (KieBaseModelImpl)this.kProject.getKieBaseModel(kBaseName);
        CompositeClassLoader cl = kieProject.getClassLoader();
        InternalKieModule kModule = kieProject.getKieModuleForKBase(kBaseModel.getName());
        Collection<KnowledgePackage> pkgs = kModule.getKnowledgePackagesForKieBase(kBaseModel.getName());
        if (pkgs == null && (kbuilder = AbstractKieModule.buildKnowledgePackages(kBaseModel, kieProject, messages)).hasErrors()) {
            return null;
        }
        pkgs = kModule.getKnowledgePackagesForKieBase(kBaseModel.getName());
        InternalKnowledgeBase kBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)(conf != null ? conf : this.getKnowledgeBaseConfiguration(kBaseModel, (ClassLoader)cl)));
        kBase.addKnowledgePackages(pkgs);
        return kBase;
    }

    private KieBaseConfiguration getKnowledgeBaseConfiguration(KieBaseModelImpl kBaseModel, ClassLoader cl) {
        KieBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{cl});
        kbConf.setOption((KieBaseOption)kBaseModel.getEqualsBehavior());
        kbConf.setOption((KieBaseOption)kBaseModel.getEventProcessingMode());
        return kbConf;
    }

    public KieSession newKieSession() {
        return this.newKieSession((Environment)null, (KieSessionConfiguration)null);
    }

    @Override
    public KieSession getKieSession() {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(false);
        return this.getKieSession(defaultKieSessionModel.getName());
    }

    public KieSession newKieSession(KieSessionConfiguration conf) {
        return this.newKieSession((Environment)null, conf);
    }

    public KieSession newKieSession(Environment environment) {
        return this.newKieSession(environment, (KieSessionConfiguration)null);
    }

    public KieSession newKieSession(Environment environment, KieSessionConfiguration conf) {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(false);
        return this.newKieSession(defaultKieSessionModel.getName(), environment, conf);
    }

    private KieSessionModel findKieSessionModel(boolean stateless) {
        KieSessionModel defaultKieSessionModel;
        KieSessionModel kieSessionModel = defaultKieSessionModel = stateless ? this.kProject.getDefaultStatelessKieSession() : this.kProject.getDefaultKieSession();
        if (defaultKieSessionModel == null) {
            throw new RuntimeException(stateless ? "Cannot find a defualt StatelessKieSession" : "Cannot find a defualt KieSession");
        }
        return defaultKieSessionModel;
    }

    public StatelessKieSession newStatelessKieSession() {
        return this.newStatelessKieSession((KieSessionConfiguration)null);
    }

    public StatelessKieSession newStatelessKieSession(KieSessionConfiguration conf) {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(true);
        return this.newStatelessKieSession(defaultKieSessionModel.getName(), conf);
    }

    @Override
    public StatelessKieSession getStatelessKieSession() {
        KieSessionModel defaultKieSessionModel = this.findKieSessionModel(true);
        return this.getStatelessKieSession(defaultKieSessionModel.getName());
    }

    public KieSession newKieSession(String kSessionName) {
        return this.newKieSession(kSessionName, null, null);
    }

    @Override
    public KieSession getKieSession(String kSessionName) {
        KieSession kieSession = this.kSessions.get(kSessionName);
        return kieSession != null ? kieSession : this.newKieSession(kSessionName);
    }

    public KieSession newKieSession(String kSessionName, Environment environment) {
        return this.newKieSession(kSessionName, environment, null);
    }

    public KieSession newKieSession(String kSessionName, KieSessionConfiguration conf) {
        return this.newKieSession(kSessionName, null, conf);
    }

    public KieSession newKieSession(String kSessionName, Environment environment, KieSessionConfiguration conf) {
        KieSessionModelImpl kSessionModel = (KieSessionModelImpl)this.getKieSessionModel(kSessionName);
        if (kSessionModel == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        if (kSessionModel.getType() == KieSessionModel.KieSessionType.STATELESS) {
            throw new RuntimeException("Trying to create a stateful KieSession from a stateless KieSessionModel: " + kSessionName);
        }
        KieBase kBase = this.getKieBase(kSessionModel.getKieBaseModel().getName());
        if (kBase == null) {
            log.error("Unknown KieBase name: " + kSessionModel.getKieBaseModel().getName());
            return null;
        }
        KieSession kSession = kBase.newKieSession(conf != null ? conf : this.getKnowledgeSessionConfiguration(kSessionModel), environment);
        CDIHelper.wireListnersAndWIHs(kSessionModel, kSession);
        KieSession oldSession = this.kSessions.remove(kSessionName);
        if (oldSession != null) {
            oldSession.dispose();
        }
        this.kSessions.put(kSessionName, kSession);
        return kSession;
    }

    public StatelessKieSession newStatelessKieSession(String kSessionName) {
        return this.newStatelessKieSession(kSessionName, null);
    }

    public StatelessKieSession newStatelessKieSession(String kSessionName, KieSessionConfiguration conf) {
        KieSessionModelImpl kSessionModel = (KieSessionModelImpl)this.kProject.getKieSessionModel(kSessionName);
        if (kSessionName == null) {
            log.error("Unknown KieSession name: " + kSessionName);
            return null;
        }
        if (kSessionModel.getType() == KieSessionModel.KieSessionType.STATEFUL) {
            throw new RuntimeException("Trying to create a stateless KieSession from a stateful KieSessionModel: " + kSessionName);
        }
        KieBase kBase = this.getKieBase(kSessionModel.getKieBaseModel().getName());
        if (kBase == null) {
            log.error("Unknown KieBase name: " + kSessionModel.getKieBaseModel().getName());
            return null;
        }
        StatelessKieSession statelessKieSession = kBase.newStatelessKieSession(conf != null ? conf : this.getKnowledgeSessionConfiguration(kSessionModel));
        this.statelessKSessions.put(kSessionName, statelessKieSession);
        return statelessKieSession;
    }

    @Override
    public StatelessKieSession getStatelessKieSession(String kSessionName) {
        StatelessKieSession kieSession = this.statelessKSessions.get(kSessionName);
        return kieSession != null ? kieSession : this.newStatelessKieSession(kSessionName);
    }

    private KieSessionConfiguration getKnowledgeSessionConfiguration(KieSessionModelImpl kSessionModel) {
        KieSessionConfiguration ksConf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksConf.setOption((KieSessionOption)kSessionModel.getClockType());
        return ksConf;
    }

    @Override
    public void dispose() {
        for (KieSession kieSession : this.kSessions.values()) {
            kieSession.dispose();
        }
        this.kSessions.clear();
        this.statelessKSessions.clear();
    }

    public KieProject getKieProject() {
        return this.kProject;
    }

    public KieModule getKieModuleForKBase(String kBaseName) {
        return this.kProject.getKieModuleForKBase(kBaseName);
    }

    @Override
    public KieBaseModel getKieBaseModel(String kBaseName) {
        return this.kProject.getKieBaseModel(kBaseName);
    }

    @Override
    public KieSessionModel getKieSessionModel(String kSessionName) {
        return this.kProject.getKieSessionModel(kSessionName);
    }

    public ClassLoader getClassLoader() {
        return this.kProject.getClassLoader();
    }
}

