/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.extractors;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.ValueType;
import org.drools.core.base.extractors.BaseObjectClassFieldReader;
import org.drools.core.base.extractors.MVELClassFieldReader;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExecutableStatement;

public class MVELObjectClassFieldReader
extends BaseObjectClassFieldReader
implements Externalizable,
MVELCompileable,
MVELClassFieldReader {
    private static final long serialVersionUID = 510L;
    private ExecutableStatement mvelExpression = null;
    private String className;
    private String expr;
    private boolean typesafe;

    public MVELObjectClassFieldReader() {
    }

    public MVELObjectClassFieldReader(String className, String expr, boolean typesafe) {
        this.className = className;
        this.expr = expr;
        this.typesafe = typesafe;
        this.setIndex(-1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = (String)in.readObject();
        this.expr = (String)in.readObject();
        this.typesafe = in.readBoolean();
        this.setIndex(-1);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.className);
        out.writeObject(this.expr);
        out.writeBoolean(this.typesafe);
    }

    @Override
    public void setExecutableStatement(ExecutableStatement expression) {
        this.mvelExpression = expression;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isTypeSafe() {
        return this.typesafe;
    }

    @Override
    public String getExpression() {
        return this.expr;
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        MVELObjectClassFieldReader.doCompile(this, runtimeData);
    }

    public static void doCompile(MVELClassFieldReader target, MVELDialectRuntimeData runtimeData) {
        Class cls = null;
        try {
            cls = runtimeData.getRootClassLoader().loadClass(target.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to compile as Class could not be found '" + target.getClassName() + "'");
        }
        ParserContext context = new ParserContext(runtimeData.getParserConfiguration());
        context.addInput("this", cls);
        context.setStrongTyping(target.isTypeSafe());
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
        MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
        ExecutableStatement mvelExpression = (ExecutableStatement)MVEL.compileExpression((String)target.getExpression(), (ParserContext)context);
        Class returnType = mvelExpression.getKnownEgressType();
        target.setExecutableStatement(mvelExpression);
        target.setFieldType(returnType);
        target.setValueType(ValueType.determineValueType(returnType));
    }

    @Override
    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return MVEL.executeExpression((Object)this.mvelExpression, (Object)object);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.typesafe ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MVELObjectClassFieldReader other = (MVELObjectClassFieldReader)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
            return false;
        }
        return this.typesafe == other.typesafe;
    }

    public String toString() {
        return "[MVELObjectClassFieldReader className=" + this.className + ", expr=" + this.expr + ", typesafe=" + this.typesafe + "]";
    }
}

