/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Rule;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.index.LeftTupleList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleNetworkEvaluatorActivation
extends AgendaItem {
    private static final Logger log = LoggerFactory.getLogger(RuleNetworkEvaluatorActivation.class);
    private PathMemory rmem;
    private static RuleNetworkEvaluator networkEvaluator = new RuleNetworkEvaluator();
    private LeftTupleList tupleList;
    private boolean dirty;
    private boolean declarativeAgendaEnabled;

    public RuleNetworkEvaluatorActivation() {
    }

    public RuleNetworkEvaluatorActivation(long activationNumber, LeftTuple tuple, int salience, PropagationContext context, PathMemory rmem, TerminalNode rtn, boolean declarativeAgendaEnabled) {
        super(activationNumber, tuple, salience, context, rtn, null);
        this.rmem = rmem;
        this.tupleList = new LeftTupleList();
        this.declarativeAgendaEnabled = declarativeAgendaEnabled;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDeclarativeAgendaEnabled() {
        return this.declarativeAgendaEnabled;
    }

    public int evaluateNetwork(InternalWorkingMemory wm, int fireCount, int fireLimit) {
        networkEvaluator.evaluateNetwork(this.rmem, wm, this);
        this.setDirty(false);
        int localFireCount = 0;
        if (!this.tupleList.isEmpty()) {
            RuleNetworkEvaluatorActivation nextRule;
            RuleTerminalNode rtn = (RuleTerminalNode)this.rmem.getRuleTerminalNode();
            Rule rule = rtn.getRule();
            InternalAgenda agenda = (InternalAgenda)wm.getAgenda();
            int salience = rule.getSalience().getValue(null, null, null);
            if (this.isDeclarativeAgendaEnabled() && !this.isHighestSalience(nextRule = agenda.peekNextRule(), salience)) {
                ((InternalAgenda)wm.getAgenda()).addActivation(this);
                return localFireCount;
            }
            while (!this.tupleList.isEmpty()) {
                InternalAgendaGroup agendaGroup;
                long handleRecency;
                LeftTuple leftTuple = this.tupleList.removeFirst();
                rtn = (RuleTerminalNode)leftTuple.getSink();
                rule = rtn.getRule();
                PropagationContext pctx = leftTuple.getPropagationContext();
                if (this.isNotEffective(wm, rtn, rule, leftTuple, pctx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, pctx)) || this.blockedByLockOnActive(rule, agenda, pctx, handleRecency = ((InternalFactHandle)pctx.getFactHandle()).getRecency(), agendaGroup = (InternalAgendaGroup)agenda.getAgendaGroup(rule.getAgendaGroup()))) continue;
                AgendaItem item = (AgendaItem)leftTuple.getObject();
                if (item == null) {
                    item = agenda.createAgendaItem(leftTuple, salience, pctx, rtn, this);
                    item.setActivated(true);
                    leftTuple.setObject(item);
                } else {
                    item.setPropagationContext(pctx);
                }
                agenda.fireActivation(item);
                RuleNetworkEvaluatorActivation nextRule2 = agenda.peekNextRule();
                if (this.haltRuleFiring(nextRule2, fireCount, fireLimit, ++localFireCount, agenda, salience)) break;
                if (!this.isDirty()) continue;
                this.dequeue();
                this.setDirty(false);
                networkEvaluator.evaluateNetwork(this.rmem, wm, this);
            }
        }
        return localFireCount;
    }

    private boolean isNotEffective(InternalWorkingMemory wm, RuleTerminalNode rtn, Rule rule, LeftTuple leftTuple, PropagationContext pctx) {
        if (!rule.isEffective(leftTuple, rtn, wm) || rule.isNoLoop() && rule.equals(pctx.getRuleOrigin())) {
            return true;
        }
        if (rule.getCalendars() != null) {
            long timestamp = wm.getSessionClock().getCurrentTime();
            for (String cal : rule.getCalendars()) {
                if (wm.getCalendars().get(cal).isTimeIncluded(timestamp)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean blockedByLockOnActive(Rule rule, InternalAgenda agenda, PropagationContext pctx, long handleRecency, InternalAgendaGroup agendaGroup) {
        if (rule.isLockOnActive()) {
            boolean isActive = false;
            long activatedForRecency = 0L;
            long clearedForRecency = 0L;
            if (rule.getRuleFlowGroup() == null) {
                isActive = agendaGroup.isActive();
                activatedForRecency = agendaGroup.getActivatedForRecency();
                clearedForRecency = agendaGroup.getClearedForRecency();
            } else {
                InternalRuleFlowGroup rfg = (InternalRuleFlowGroup)agenda.getRuleFlowGroup(rule.getRuleFlowGroup());
                isActive = rfg.isActive();
                activatedForRecency = rfg.getActivatedForRecency();
                clearedForRecency = rfg.getClearedForRecency();
            }
            if (isActive && activatedForRecency < handleRecency && agendaGroup.getAutoFocusActivator() != pctx) {
                return true;
            }
            if (clearedForRecency != -1L && clearedForRecency >= handleRecency) {
                return true;
            }
        }
        return false;
    }

    private boolean haltRuleFiring(RuleNetworkEvaluatorActivation nextRule, int fireCount, int fireLimit, int localFireCount, InternalAgenda agenda, int salience) {
        return !agenda.continueFiring(0) || !this.isHighestSalience(nextRule, salience) || fireLimit >= 0 && localFireCount + fireCount >= fireLimit;
    }

    public boolean isHighestSalience(RuleNetworkEvaluatorActivation nextRule, int currentSalience) {
        return nextRule == null || nextRule.getRule().getSalience().getValue(null, null, null) <= currentSalience;
    }

    @Override
    public boolean isRuleNetworkEvaluatorActivation() {
        return true;
    }

    public LeftTupleList getLeftTupleList() {
        return this.tupleList;
    }
}

