/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.AbstractLeftTupleSinkAdapter;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkNodeList;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.spi.PropagationContext;

public class CompositeLeftTupleSinkAdapter
extends AbstractLeftTupleSinkAdapter {
    private LeftTupleSinkNodeList sinks;

    public CompositeLeftTupleSinkAdapter() {
        super(RuleBasePartitionId.MAIN_PARTITION);
    }

    public CompositeLeftTupleSinkAdapter(RuleBasePartitionId partitionId) {
        super(partitionId);
        this.sinks = new LeftTupleSinkNodeList();
    }

    public void addTupleSink(LeftTupleSink sink) {
        this.sinks.add((LeftTupleSinkNode)sink);
    }

    public void removeTupleSink(LeftTupleSink sink) {
        this.sinks.remove((LeftTupleSinkNode)sink);
    }

    public LeftTupleSinkNodeList getRawSinks() {
        return this.sinks;
    }

    @Override
    public void createChildLeftTuplesforQuery(LeftTuple leftTuple, RightTuple rightTuple, boolean leftTupleMemoryEnabled, boolean linkRightTuple) {
        for (LeftTupleSinkNode sink = this.sinks.getLast(); sink != null; sink = sink.getPreviousLeftTupleSinkNode()) {
            LeftTuple child = sink.createLeftTuple(leftTuple, rightTuple, (LeftTupleSink)sink);
        }
    }

    @Override
    public void modifyChildLeftTuplesforQuery(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (LeftTuple childLeftTuple = rightTuple.firstChild; childLeftTuple != null; childLeftTuple = childLeftTuple.getRightParentNext()) {
            childLeftTuple.getLeftTupleSink().modifyLeftTuple(childLeftTuple, context, workingMemory);
        }
    }

    @Override
    public void propagateAssertLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            LeftTuple newLeftTuple = sink.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
            this.doPropagateAssertLeftTuple(context, workingMemory, sink, newLeftTuple);
        }
    }

    @Override
    public void propagateAssertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            this.doPropagateAssertLeftTuple(context, workingMemory, sink, sink.createLeftTuple(tuple, sink, context, leftTupleMemoryEnabled));
        }
    }

    @Override
    public void createAndPropagateAssertLeftTuple(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled, LeftInputAdapterNode liaNode) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            LeftTuple lt = sink.createLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
            lt.setPropagationContext(context);
            this.doPropagateAssertLeftTuple(context, workingMemory, sink, lt);
        }
    }

    @Override
    public void propagateRetractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = leftTuple.getFirstChild();
        while (child != null) {
            LeftTuple temp = child.getLeftParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, child, child.getLeftTupleSink());
            child.unlinkFromRightParent();
            child.unlinkFromLeftParent();
            child = temp;
        }
    }

    @Override
    public void propagateRetractLeftTupleDestroyRightTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = leftTuple.getFirstChild();
        InternalFactHandle rightParent = child.getRightParent().getFactHandle();
        while (child != null) {
            LeftTuple temp = child.getLeftParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, child, child.getLeftTupleSink());
            child.unlinkFromRightParent();
            child.unlinkFromLeftParent();
            child = temp;
        }
    }

    @Override
    public void propagateRetractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = rightTuple.firstChild;
        while (child != null) {
            LeftTuple temp = child.getRightParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, child, child.getLeftTupleSink());
            child.unlinkFromLeftParent();
            child.unlinkFromRightParent();
            child = temp;
        }
    }

    @Override
    public BaseNode getMatchingNode(BaseNode candidate) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            if (!candidate.equals(sink)) continue;
            return (BaseNode)((Object)sink);
        }
        return null;
    }

    @Override
    public LeftTupleSink[] getSinks() {
        LeftTupleSink[] sinkArray = new LeftTupleSink[this.sinks.size()];
        int i = 0;
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            sinkArray[i++] = sink;
        }
        return sinkArray;
    }

    @Override
    public LeftTupleSinkNode getFirstLeftTupleSink() {
        return this.sinks.getFirst();
    }

    @Override
    public int size() {
        return this.sinks.size();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sinks = (LeftTupleSinkNodeList)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sinks);
    }

    @Override
    public void doPropagateAssertLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple, LeftTupleSink sink) {
        sink.assertLeftTuple(leftTuple, context, workingMemory);
    }

    protected void doPropagateAssertLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTupleSinkNode sink, LeftTuple leftTuple) {
        sink.assertLeftTuple(leftTuple, context, workingMemory);
    }

    protected void doPropagateRetractLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple, LeftTupleSink sink) {
        sink.retractLeftTuple(leftTuple, context, workingMemory);
    }

    public void doPropagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory, LeftTupleSink sink) {
        sink.modifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    @Override
    public void propagateModifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            this.doPropagateModifyObject(factHandle, modifyPreviousTuples, context, workingMemory, sink);
        }
    }

    @Override
    public LeftTuple propagateModifyChildLeftTuple(LeftTuple childLeftTuple, RightTuple parentRightTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean tupleMemoryEnabled) {
        while (childLeftTuple != null && childLeftTuple.getRightParent() == parentRightTuple) {
            LeftTuple temp = childLeftTuple;
            childLeftTuple.getLeftTupleSink().modifyLeftTuple(childLeftTuple, context, workingMemory);
            childLeftTuple = childLeftTuple.getLeftParentNext();
            temp.reAddRight();
        }
        return childLeftTuple;
    }

    @Override
    public LeftTuple propagateModifyChildLeftTuple(LeftTuple childLeftTuple, LeftTuple parentLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean tupleMemoryEnabled) {
        while (childLeftTuple != null && childLeftTuple.getLeftParent() == parentLeftTuple) {
            LeftTuple temp = childLeftTuple;
            childLeftTuple.getLeftTupleSink().modifyLeftTuple(childLeftTuple, context, workingMemory);
            childLeftTuple = childLeftTuple.getRightParentNext();
            temp.reAddLeft();
        }
        return childLeftTuple;
    }

    @Override
    public void propagateModifyChildLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean tupleMemoryEnabled) {
        for (LeftTuple childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
            childLeftTuple.getLeftTupleSink().modifyLeftTuple(childLeftTuple, context, workingMemory);
        }
    }

    @Override
    public LeftTuple propagateRetractChildLeftTuple(LeftTuple childLeftTuple, RightTuple parentRightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        while (childLeftTuple != null && childLeftTuple.getRightParent() == parentRightTuple) {
            LeftTuple temp = childLeftTuple.getLeftParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, childLeftTuple, childLeftTuple.getLeftTupleSink());
            childLeftTuple.unlinkFromRightParent();
            childLeftTuple.unlinkFromLeftParent();
            childLeftTuple = temp;
        }
        return childLeftTuple;
    }

    @Override
    public LeftTuple propagateRetractChildLeftTuple(LeftTuple childLeftTuple, LeftTuple parentLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        while (childLeftTuple != null && childLeftTuple.getLeftParent() == parentLeftTuple) {
            LeftTuple temp = childLeftTuple.getRightParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, childLeftTuple, childLeftTuple.getLeftTupleSink());
            childLeftTuple.unlinkFromRightParent();
            childLeftTuple.unlinkFromLeftParent();
            childLeftTuple = temp;
        }
        return childLeftTuple;
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            sink.modifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory);
        }
    }
}

