/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.preferences;

import java.io.File;
import java.util.List;
import org.drools.eclipse.util.DroolsRuntime;
import org.drools.eclipse.util.DroolsRuntimeManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DroolsRuntimeDialog
extends Dialog {
    private DroolsRuntime runtime;
    private Text nameText;
    private Text pathText;
    private List<DroolsRuntime> runtimes;
    private Listener textModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = DroolsRuntimeDialog.this.validate();
            DroolsRuntimeDialog.this.getButton(0).setEnabled(valid);
        }
    };

    public DroolsRuntimeDialog(Shell parent, List<DroolsRuntime> runtimes) {
        super(parent);
        this.setBlockOnOpen(true);
        this.runtimes = runtimes;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 64);
        label.setFont(composite.getFont());
        label.setText("Either select an existing Drools Runtime on your file system or create a new one.");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 450;
        label.setLayoutData((Object)gridData);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name: ");
        this.nameText = new Text(composite, 2052);
        this.nameText.setText(this.runtime == null || this.runtime.getName() == null ? "" : this.runtime.getName());
        this.nameText.addListener(24, this.textModifyListener);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.nameText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Path: ");
        this.pathText = new Text(composite, 2052);
        this.pathText.setText(this.runtime == null || this.runtime.getPath() == null ? "" : this.runtime.getPath());
        this.pathText.addListener(24, this.textModifyListener);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.pathText.setLayoutData((Object)gridData);
        Button selectButton = new Button(composite, 16392);
        selectButton.setText("Browse ...");
        gridData = new GridData();
        selectButton.setLayoutData((Object)gridData);
        selectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DroolsRuntimeDialog.this.browse();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button createButton = new Button(composite, 16392);
        createButton.setText("Create a new Drools 5 Runtime ...");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        createButton.setLayoutData((Object)gridData);
        createButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DroolsRuntimeDialog.this.createRuntime();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Drools Runtime");
    }

    protected Point getInitialSize() {
        return new Point(500, 250);
    }

    public void setDroolsRuntime(DroolsRuntime runtime) {
        this.runtime = runtime;
    }

    private boolean validate() {
        File file;
        String location;
        String name = this.nameText.getText();
        if (name == null || "".equals(name.trim())) {
            return false;
        }
        if (this.runtime == null || !name.equals(this.runtime.getName())) {
            for (DroolsRuntime runtime : this.runtimes) {
                if (!name.equals(runtime.getName())) continue;
                return false;
            }
        }
        return (location = this.pathText.getText()) != null && (file = new File(location)).exists() && file.isDirectory();
    }

    private void browse() {
        String selectedDirectory = null;
        String dirName = this.pathText.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage("Select the Drools runtime directory.");
        dialog.setFilterPath(dirName);
        selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.pathText.setText(selectedDirectory);
        }
    }

    private void createRuntime() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage("Select the new Drools 5 runtime directory.");
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            DroolsRuntimeManager.createDefaultRuntime(selectedDirectory);
            String version = Platform.getBundle((String)"org.drools.eclipse").getVersion().toString();
            this.nameText.setText("Drools " + version + " runtime");
            this.pathText.setText(selectedDirectory);
        }
    }

    public DroolsRuntime getResult() {
        return this.runtime;
    }

    protected void okPressed() {
        this.runtime = new DroolsRuntime();
        this.runtime.setName(this.nameText.getText());
        this.runtime.setPath(this.pathText.getText());
        super.okPressed();
    }
}

