/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.drools.core.base.SalienceInteger;
import org.drools.core.base.mvel.MVELEnabledExpression;
import org.drools.core.base.mvel.MVELSalienceExpression;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.PropagationContextImpl;
import org.drools.core.common.ScheduledAgendaItem;
import org.drools.core.common.TruthMaintenanceSystemHelper;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeSet;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.Rule;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.impl.ExpressionIntervalTimer;
import org.kie.api.event.rule.MatchCancelledCause;

public class RuleTerminalNode
extends AbstractTerminalNode {
    private int sequence = -1;
    private static final long serialVersionUID = 510L;
    private Rule rule;
    private GroupElement subrule;
    private int subruleIndex;
    private Declaration[] declarations;
    private Declaration[] timerDelayDeclarations;
    private Declaration[] timerPeriodDeclarations;
    private Declaration[] salienceDeclarations;
    private Declaration[] enabledDeclarations;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private boolean fireDirect;
    private transient ObjectTypeNode.Id leftInputOtnId;
    private String consequenceName;
    private boolean unlinkingEnabled;

    public RuleTerminalNode() {
    }

    public RuleTerminalNode(int id, LeftTupleSource source, Rule rule, GroupElement subrule, int subruleIndex, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), source);
        this.rule = rule;
        this.subrule = subrule;
        this.subruleIndex = subruleIndex;
        this.unlinkingEnabled = context.getRuleBase().getConfiguration().isPhreakEnabled();
        this.setFireDirect(rule.getActivationListener().equals("direct"));
        if (this.isFireDirect()) {
            rule.setSalience(new SalienceInteger(Integer.MAX_VALUE));
        }
        this.setDeclarations(this.subrule.getOuterDeclarations());
        this.initDeclaredMask(context);
        this.initInferredMask();
    }

    public void setDeclarations(Map<String, Declaration> decls) {
        int i;
        Declaration[] declrs;
        Externalizable expr;
        if (this.rule.getSalience() instanceof MVELSalienceExpression) {
            expr = (MVELSalienceExpression)this.rule.getSalience();
            declrs = ((MVELSalienceExpression)expr).getMVELCompilationUnit().getPreviousDeclarations();
            this.salienceDeclarations = new Declaration[declrs.length];
            i = 0;
            for (Declaration declr : declrs) {
                this.salienceDeclarations[i++] = decls.get(declr.getIdentifier());
            }
            Arrays.sort(this.salienceDeclarations, SortDeclarations.instance);
        }
        if (this.rule.getEnabled() instanceof MVELEnabledExpression) {
            expr = (MVELEnabledExpression)this.rule.getEnabled();
            declrs = ((MVELEnabledExpression)expr).getMVELCompilationUnit().getPreviousDeclarations();
            this.enabledDeclarations = new Declaration[declrs.length];
            i = 0;
            for (Declaration declr : declrs) {
                this.enabledDeclarations[i++] = decls.get(declr.getIdentifier());
            }
            Arrays.sort(this.enabledDeclarations, SortDeclarations.instance);
        }
        if (this.rule.getTimer() instanceof ExpressionIntervalTimer) {
            expr = (ExpressionIntervalTimer)this.rule.getTimer();
            declrs = ((ExpressionIntervalTimer)expr).getDelayMVELCompilationUnit().getPreviousDeclarations();
            this.timerDelayDeclarations = new Declaration[declrs.length];
            i = 0;
            for (Declaration declr : declrs) {
                this.timerDelayDeclarations[i++] = decls.get(declr.getIdentifier());
            }
            Arrays.sort(this.timerDelayDeclarations, SortDeclarations.instance);
            declrs = ((ExpressionIntervalTimer)expr).getPeriodMVELCompilationUnit().getPreviousDeclarations();
            this.timerPeriodDeclarations = new Declaration[declrs.length];
            i = 0;
            for (Declaration declr : declrs) {
                this.timerPeriodDeclarations[i++] = decls.get(declr.getIdentifier());
            }
            Arrays.sort(this.timerPeriodDeclarations, SortDeclarations.instance);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sequence = in.readInt();
        this.rule = (Rule)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.subruleIndex = in.readInt();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.timerDelayDeclarations = (Declaration[])in.readObject();
        this.timerPeriodDeclarations = (Declaration[])in.readObject();
        this.salienceDeclarations = (Declaration[])in.readObject();
        this.enabledDeclarations = (Declaration[])in.readObject();
        this.consequenceName = (String)in.readObject();
        this.fireDirect = this.rule.getActivationListener().equals("direct");
        this.unlinkingEnabled = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.sequence);
        out.writeObject(this.rule);
        out.writeObject(this.subrule);
        out.writeInt(this.subruleIndex);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
        out.writeObject(this.declarations);
        out.writeObject(this.timerDelayDeclarations);
        out.writeObject(this.timerPeriodDeclarations);
        out.writeObject(this.salienceDeclarations);
        out.writeObject(this.enabledDeclarations);
        out.writeObject(this.consequenceName);
        out.writeBoolean(this.unlinkingEnabled);
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public GroupElement getSubRule() {
        return this.subrule;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.unlinkingEnabled) {
            context = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, context);
        }
        if (!this.rule.isEffective(leftTuple, this, workingMemory) || this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            leftTuple.setObject(Boolean.TRUE);
            return;
        }
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        boolean fire = agenda.createActivation(leftTuple, context, workingMemory, this);
        if (fire && !this.fireDirect) {
            agenda.addActivation((AgendaItem)leftTuple.getObject());
        }
    }

    public static PropagationContext findMostRecentPropagationContext(LeftTuple leftTuple, PropagationContext context) {
        for (LeftTuple lt = leftTuple; lt != null; lt = lt.getParent()) {
            if (lt.getPropagationContext() == null || lt.getPropagationContext().getPropagationNumber() <= context.getPropagationNumber()) continue;
            context = lt.getPropagationContext();
        }
        return context;
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        boolean fire;
        AgendaItem match;
        if (this.unlinkingEnabled) {
            context = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, context);
        }
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        Object o = leftTuple.getObject();
        if (o != Boolean.TRUE && (match = (AgendaItem)o) != null && match.isQueued()) {
            agenda.modifyActivation(match, true);
            return;
        }
        if (!this.rule.isEffective(leftTuple, this, workingMemory) || this.rule.isNoLoop() && this.rule.equals(context.getRuleOrigin())) {
            return;
        }
        if (o == null || o == Boolean.TRUE) {
            leftTuple.setObject(null);
        }
        if ((fire = agenda.createActivation(leftTuple, context, workingMemory, this)) && !this.isFireDirect()) {
            agenda.modifyActivation((AgendaItem)leftTuple.getObject(), false);
        }
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object obj = leftTuple.getObject();
        if (obj == null || obj == Boolean.TRUE) {
            return;
        }
        Activation activation = (Activation)obj;
        activation.setMatched(false);
        InternalAgenda agenda = (InternalAgenda)workingMemory.getAgenda();
        agenda.cancelActivation(leftTuple, context, workingMemory, activation, this);
        ((RuleTerminalNodeLeftTuple)leftTuple).setActivationUnMatchListener(null);
    }

    @Override
    public String toString() {
        return "[RuleTerminalNode(" + this.getId() + "): rule=" + this.rule.getName() + "]";
    }

    @Override
    public void attach(BuildContext context) {
        this.getLeftTupleSource().addTupleSink(this, context);
        if (context == null || context.getRuleBase().getConfiguration().isPhreakEnabled()) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.getLeftTupleSource().updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.getLeftTupleSource().networkUpdated(updateContext);
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        this.getLeftTupleSource().removeTupleSink(this);
    }

    @Override
    protected void doCollectAncestors(NodeSet nodeSet) {
        this.getLeftTupleSource().collectAncestors(nodeSet);
    }

    @Override
    public boolean isInUse() {
        return false;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
    }

    @Override
    public Declaration[] getDeclarations() {
        if (this.declarations == null) {
            Map<String, Declaration> decls = this.subrule.getOuterDeclarations();
            String[] requiredDeclarations = this.rule.getRequiredDeclarationsForConsequence(this.getConsequenceName());
            this.declarations = new Declaration[requiredDeclarations.length];
            int i = 0;
            for (String str : requiredDeclarations) {
                this.declarations[i++] = decls.get(str);
            }
            Arrays.sort(this.declarations, SortDeclarations.instance);
        }
        return this.declarations;
    }

    @Override
    public Declaration[] getTimerDelayDeclarations() {
        return this.timerDelayDeclarations;
    }

    public void setTimerDelayDeclarations(Declaration[] timerDelayDeclarations) {
        this.timerDelayDeclarations = timerDelayDeclarations;
    }

    @Override
    public Declaration[] getTimerPeriodDeclarations() {
        return this.timerPeriodDeclarations;
    }

    public void setTimerPeriodDeclarations(Declaration[] timerPeriodDeclarations) {
        this.timerPeriodDeclarations = timerPeriodDeclarations;
    }

    @Override
    public Declaration[] getSalienceDeclarations() {
        return this.salienceDeclarations;
    }

    public void setSalienceDeclarations(Declaration[] salienceDeclarations) {
        this.salienceDeclarations = salienceDeclarations;
    }

    public Declaration[] getEnabledDeclarations() {
        return this.enabledDeclarations;
    }

    public void setEnabledDeclarations(Declaration[] enabledDeclarations) {
        this.enabledDeclarations = enabledDeclarations;
    }

    public String getConsequenceName() {
        return this.consequenceName == null ? "default" : this.consequenceName;
    }

    public void setConsequenceName(String consequenceName) {
        this.consequenceName = consequenceName;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public int hashCode() {
        return this.rule.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RuleTerminalNode)) {
            return false;
        }
        RuleTerminalNode other = (RuleTerminalNode)object;
        return this.rule.equals(other.rule) && (this.consequenceName == null ? other.consequenceName == null : this.consequenceName.equals(other.consequenceName));
    }

    @Override
    public short getType() {
        return 101;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        return new RuleTerminalNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public ObjectTypeNode.Id getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    @Override
    public void setLeftInputOtnId(ObjectTypeNode.Id leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }

    @Override
    public boolean isFireDirect() {
        return this.fireDirect;
    }

    public void setFireDirect(boolean fireDirect) {
        this.fireDirect = fireDirect;
    }

    protected ObjectTypeNode getObjectTypeNode() {
        return this.getLeftTupleSource().getObjectTypeNode();
    }

    public static class RTNCleanupAdapter
    implements RuleRemovalContext.CleanupAdapter {
        private final RuleTerminalNode node;

        public RTNCleanupAdapter(RuleTerminalNode node) {
            this.node = node;
        }

        @Override
        public void cleanUp(LeftTuple leftTuple, InternalWorkingMemory workingMemory) {
            if (leftTuple.getLeftTupleSink() != this.node) {
                return;
            }
            Activation activation = (Activation)leftTuple.getObject();
            if (activation instanceof ScheduledAgendaItem) {
                ScheduledAgendaItem scheduled = (ScheduledAgendaItem)activation;
                workingMemory.getTimerService().removeJob(scheduled.getJobHandle());
                scheduled.getJobHandle().setCancel(true);
            }
            if (activation.isQueued()) {
                activation.remove();
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory, MatchCancelledCause.CLEAR);
            }
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 4, null, null, null);
            TruthMaintenanceSystemHelper.removeLogicalDependencies(activation, propagationContext, this.node.getRule());
            leftTuple.unlinkFromLeftParent();
            leftTuple.unlinkFromRightParent();
        }
    }

    public static class SortDeclarations
    implements Comparator<Declaration> {
        public static final SortDeclarations instance = new SortDeclarations();

        @Override
        public int compare(Declaration d1, Declaration d2) {
            return d1.getIdentifier().compareTo(d2.getIdentifier());
        }
    }
}

