/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.util.Arrays;
import java.util.Map;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.BuildUtils;
import org.drools.core.reteoo.builder.ReteooComponentBuilder;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.time.impl.ExpressionIntervalTimer;
import org.drools.core.time.impl.Timer;

public class TimerBuilder
implements ReteooComponentBuilder {
    @Override
    public void build(BuildContext context, BuildUtils utils, RuleConditionElement rce) {
        Timer timer = (Timer)rce;
        context.pushRuleComponent(timer);
        Declaration[][] declrs = null;
        if (timer instanceof ExpressionIntervalTimer) {
            int i;
            Map<String, Declaration> outerDeclrs = context.getSubRule().getOuterDeclarations();
            ExpressionIntervalTimer exprTimer = (ExpressionIntervalTimer)timer;
            Declaration[] delayDeclrs = exprTimer.getDelayMVELCompilationUnit().getPreviousDeclarations();
            Declaration[] periodDeclrs = exprTimer.getPeriodMVELCompilationUnit().getPreviousDeclarations();
            delayDeclrs = Arrays.copyOf(delayDeclrs, delayDeclrs.length);
            periodDeclrs = Arrays.copyOf(periodDeclrs, delayDeclrs.length);
            for (i = 0; i < delayDeclrs.length; ++i) {
                delayDeclrs[i] = outerDeclrs.get(delayDeclrs[i].getIdentifier());
            }
            Arrays.sort(delayDeclrs, RuleTerminalNode.SortDeclarations.instance);
            for (i = 0; i < periodDeclrs.length; ++i) {
                periodDeclrs[i] = outerDeclrs.get(periodDeclrs[i].getIdentifier());
            }
            Arrays.sort(periodDeclrs, RuleTerminalNode.SortDeclarations.instance);
            declrs = new Declaration[][]{delayDeclrs, periodDeclrs};
        }
        context.setTupleSource((LeftTupleSource)utils.attachNode(context, context.getComponentFactory().getNodeFactoryService().buildTimerNode(context.getNextId(), timer, context.getRule().getCalendars(), declrs, context.getTupleSource(), context)));
        context.setAlphaConstraints(null);
        context.setBetaconstraints(null);
        context.popRuleComponent();
    }

    @Override
    public boolean requiresLeftActivation(BuildUtils utils, RuleConditionElement rce) {
        return true;
    }
}

