/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.AbstractKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.ClassUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.internal.utils.ClassLoaderUtil;
import org.kie.internal.utils.CompositeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieModuleKieProject
extends AbstractKieProject {
    private static final Logger log = LoggerFactory.getLogger(KieModuleKieProject.class);
    private List<InternalKieModule> kieModules;
    private final Map<String, InternalKieModule> kJarFromKBaseName = new HashMap<String, InternalKieModule>();
    private final InternalKieModule kieModule;
    private final CompositeClassLoader cl;

    public KieModuleKieProject(InternalKieModule kieModule) {
        this.kieModule = kieModule;
        this.cl = ClassLoaderUtil.getClassLoader(null, null, (boolean)true);
    }

    @Override
    public void init() {
        if (this.kieModules == null) {
            this.kieModules = new ArrayList<InternalKieModule>();
            this.kieModules.addAll(this.kieModule.getDependencies().values());
            this.kieModules.add(this.kieModule);
            this.indexParts(this.kieModules, this.kJarFromKBaseName);
            this.initClassLoader();
        }
    }

    private void initClassLoader() {
        Map<String, byte[]> classes = this.getClassesMap();
        if (!classes.isEmpty()) {
            this.cl.addClassLoaderToEnd((ClassLoader)new ClassUtils.MapClassLoader(classes, (ClassLoader)this.cl));
        }
    }

    private Map<String, byte[]> getClassesMap() {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (InternalKieModule kModule : this.kieModules) {
            classes.putAll(kModule.getClassesMap());
        }
        return classes;
    }

    @Override
    public ReleaseId getGAV() {
        return this.kieModule.getReleaseId();
    }

    @Override
    public InternalKieModule getKieModuleForKBase(String kBaseName) {
        return this.kJarFromKBaseName.get(kBaseName);
    }

    @Override
    public CompositeClassLoader getClassLoader() {
        return this.cl;
    }
}

