/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DroolsDebugViewContentProvider
implements ITreeContentProvider {
    private Map parentCache = new HashMap(10);

    public Object[] getChildren(Object parent) {
        return null;
    }

    public Object[] getElements(Object parent) {
        Object[] result = this.getChildren(parent);
        if (result != null && result.length == 0) {
            return new Object[]{this.getEmptyString()};
        }
        return result;
    }

    protected String getEmptyString() {
        return "Empty";
    }

    protected void cache(Object parent, Object[] children) {
        int i = 0;
        while (i < children.length) {
            this.parentCache.put(children[i], parent);
            ++i;
        }
    }

    public Object getParent(Object item) {
        return this.parentCache.get(item);
    }

    public void dispose() {
        this.parentCache = null;
    }

    protected void clearCache() {
        if (this.parentCache != null) {
            this.parentCache.clear();
        }
    }

    public void removeCache(Object[] children) {
        if (this.parentCache == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            this.parentCache.remove(children[i]);
            ++i;
        }
    }

    public boolean hasChildren(Object element) {
        try {
            if (element instanceof IVariable) {
                IValue v = ((IVariable)element).getValue();
                return v != null && v.hasVariables();
            }
            if (element instanceof IValue) {
                return ((IValue)element).hasVariables();
            }
            if (element instanceof IStackFrame) {
                return ((IStackFrame)element).hasVariables();
            }
        }
        catch (DebugException e) {
            DroolsEclipsePlugin.log(e);
            return false;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clearCache();
    }

    public List getCachedDecendants(Object parent) {
        Iterator children = this.parentCache.keySet().iterator();
        ArrayList cachedChildren = new ArrayList(10);
        while (children.hasNext()) {
            Object child = children.next();
            if (!this.isCachedDecendant(child, parent)) continue;
            cachedChildren.add(child);
        }
        return cachedChildren;
    }

    protected boolean isCachedDecendant(Object child, Object parent) {
        Object p = this.getParent(child);
        while (p != null) {
            if (p.equals(parent)) {
                return true;
            }
            p = this.getParent(p);
        }
        return false;
    }

    protected IValue getLogicalValue(IValue value, List previousStructureIds) {
        ILogicalStructureType type;
        ILogicalStructureType[] types = DebugPlugin.getLogicalStructureTypes((IValue)value);
        if (types.length > 0 && (type = DebugPlugin.getDefaultStructureType((ILogicalStructureType[])types)) != null && !previousStructureIds.contains(type.getId())) {
            try {
                value = type.getLogicalStructure(value);
                previousStructureIds.add(type.getId());
                return this.getLogicalValue(value, previousStructureIds);
            }
            catch (CoreException coreException) {}
        }
        return value;
    }
}

