/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug.core;

import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.core.DroolsStackFrame;
import org.drools.eclipse.debug.core.MVELStackFrame;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class DroolsThread
extends JDIThread {
    public DroolsThread(JDIDebugTarget target, ThreadReference thread) throws ObjectCollectedException {
        super(target, thread);
    }

    protected synchronized List computeStackFrames(boolean refreshChildren) throws DebugException {
        List fStackFrames = this.getInternalfStackFrames();
        if (this.isSuspended()) {
            if (this.isTerminated()) {
                fStackFrames.clear();
            } else if (refreshChildren) {
                List frames = this.getInternalUnderlyingFrames();
                int oldSize = fStackFrames.size();
                int newSize = frames.size();
                int discard = oldSize - newSize;
                int i = 0;
                while (i < discard) {
                    DroolsStackFrame invalid = (DroolsStackFrame)((Object)fStackFrames.remove(0));
                    invalid.bind(null, -1);
                    ++i;
                }
                int newFrames = newSize - oldSize;
                int depth = oldSize;
                int i2 = newFrames - 1;
                while (i2 >= 0) {
                    StackFrame currentFrame = (StackFrame)frames.get(i2);
                    DroolsStackFrame customFrame = DroolsThread.createCustomFrame(this, depth, currentFrame);
                    fStackFrames.add(0, customFrame);
                    ++depth;
                    --i2;
                }
                int numToRebind = Math.min(newSize, oldSize);
                int offset = newSize - 1;
                depth = 0;
                while (depth < numToRebind) {
                    StackFrame frame;
                    DroolsStackFrame oldFrame = (DroolsStackFrame)((Object)fStackFrames.get(offset));
                    DroolsStackFrame newFrame = (DroolsStackFrame)oldFrame.bind(frame = (StackFrame)frames.get(offset), depth);
                    if (newFrame != oldFrame) {
                        fStackFrames.set(offset, newFrame);
                    }
                    --offset;
                    ++depth;
                }
            }
        } else {
            return Collections.EMPTY_LIST;
        }
        this.setInternalfRefreshChildren(false);
        return fStackFrames;
    }

    public static final synchronized DroolsStackFrame createCustomFrame(DroolsThread thread, int depth, StackFrame currentFrame) {
        Location loc = currentFrame.location();
        DroolsStackFrame customFrame = loc.declaringType().name().equals("org.drools.core.base.mvel.MVELDebugHandler") && loc.method().name().equals("onBreak") ? new MVELStackFrame(thread, currentFrame, depth) : new DroolsStackFrame(thread, currentFrame, depth);
        return customFrame;
    }

    public synchronized void stepOver() throws DebugException {
        if (!(this.getTopStackFrame() instanceof MVELStackFrame)) {
            super.stepOver();
            return;
        }
        MVELStackFrame mvelStack = (MVELStackFrame)this.getTopStackFrame();
        if (!this.canStepOver() || !mvelStack.canStepOver()) {
            return;
        }
        if (!this.setRemoteOnBreakReturn(1)) {
            return;
        }
        this.setRunning(true);
        this.preserveStackFrames();
        this.fireEvent(new DebugEvent((Object)this, 1, 2));
        try {
            this.getUnderlyingThread().resume();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIThread_exception_stepping, e.toString()), e);
        }
    }

    private boolean setRemoteOnBreakReturn(int step_over) throws DebugException {
        JDIStackFrame top = (JDIStackFrame)this.getTopStackFrame();
        if (top == null || !(top instanceof MVELStackFrame)) {
            return false;
        }
        Iterator<ReferenceType> handleriter = this.getVM().classesByName("org.drools.core.base.mvel.MVELDebugHandler").iterator();
        ReferenceType debugHandlerClass = handleriter.next();
        int line = step_over;
        ReferenceType refType = debugHandlerClass;
        Method m = refType.methodsByName("setOnBreakReturn").iterator().next();
        ArrayList<IntegerValue> args = new ArrayList<IntegerValue>();
        IntegerValue lineVal = this.getVM().mirrorOf(line);
        args.add(lineVal);
        try {
            ClassType tt = (ClassType)debugHandlerClass;
            tt.invokeMethod(this.getUnderlyingThread(), m, args, 1);
        }
        catch (Exception e) {
            DroolsEclipsePlugin.log(e);
            return false;
        }
        return true;
    }

    public synchronized void resume() throws DebugException {
        this.setRemoteOnBreakReturn(0);
        super.resume();
    }

    protected synchronized void disposeStackFrames() {
        super.disposeStackFrames();
    }

    protected void terminated() {
        super.terminated();
    }

    protected void removeCurrentBreakpoint(IBreakpoint bp) {
        super.removeCurrentBreakpoint(bp);
    }

    protected synchronized void suspendedByVM() {
        super.suspendedByVM();
    }

    protected synchronized void resumedByVM() throws DebugException {
        super.resumedByVM();
    }

    protected void setRunning(boolean running) {
        super.setRunning(running);
    }

    public void setInternalfRefreshChildren(boolean bool) {
        try {
            Field field = JDIThread.class.getDeclaredField("fRefreshChildren");
            field.setAccessible(true);
            field.set((Object)this, bool);
        }
        catch (Exception exception) {}
    }

    public List getInternalfStackFrames() {
        try {
            Field field = JDIThread.class.getDeclaredField("fStackFrames");
            field.setAccessible(true);
            return (List)field.get((Object)this);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List getInternalUnderlyingFrames() throws DebugException {
        try {
            java.lang.reflect.Method method = JDIThread.class.getDeclaredMethod("getUnderlyingFrames", null);
            method.setAccessible(true);
            return (List)method.invoke((Object)this, null);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

