/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.util.List;
import java.util.Map;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.ProcessInfo;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.DescrUtil;
import org.drools.eclipse.editors.RuleFlowGroupHyperlink;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.jbpm.workflow.core.node.RuleSetNode;

public class DRLHyperlinkDetector
implements IHyperlinkDetector {
    private AbstractRuleEditor editor;

    public DRLHyperlinkDetector(AbstractRuleEditor editor) {
        this.editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        BaseDescr descr = this.getDescr(region.getOffset());
        if (descr instanceof AttributeDescr) {
            return this.createHyperlinks((AttributeDescr)descr);
        }
        return null;
    }

    protected IHyperlink[] createHyperlinks(AttributeDescr descr) {
        Map<ProcessInfo, List<RuleSetNode>> nodes;
        if (descr.getName().equals("ruleflow-group") && (nodes = DroolsEclipsePlugin.getDefault().getRuleSetNodeByFlowGroup(descr.getValue())).size() > 0) {
            IHyperlink[] result = new IHyperlink[nodes.size()];
            int i = 0;
            for (ProcessInfo processInfo : nodes.keySet()) {
                result[i++] = new RuleFlowGroupHyperlink(descr, processInfo, nodes.get(processInfo));
            }
            return result;
        }
        return null;
    }

    private BaseDescr getDescr(int offset) {
        try {
            DRLInfo info = DroolsEclipsePlugin.getDefault().parseResource(this.editor, true, false);
            return DescrUtil.getDescr((BaseDescr)info.getPackageDescr(), offset);
        }
        catch (DroolsParserException droolsParserException) {
            return null;
        }
    }
}

