/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.util.HashMap;
import java.util.Map;
import org.drools.eclipse.flow.common.editor.core.DefaultElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.NodeWrapper;
import org.drools.eclipse.flow.ruleflow.view.property.metadata.MetaDataPropertyDescriptor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.kie.api.definition.process.NodeContainer;

public abstract class AbstractNodeWrapper
extends DefaultElementWrapper
implements NodeWrapper {
    private static final long serialVersionUID = 510L;
    public static IPropertyDescriptor[] DESCRIPTORS = new IPropertyDescriptor[DefaultElementWrapper.DESCRIPTORS.length + 1];
    public static final String METADATA = "MetaData";

    static {
        System.arraycopy(DefaultElementWrapper.DESCRIPTORS, 0, DESCRIPTORS, 0, DefaultElementWrapper.DESCRIPTORS.length);
        AbstractNodeWrapper.DESCRIPTORS[AbstractNodeWrapper.DESCRIPTORS.length - 1] = new MetaDataPropertyDescriptor(METADATA, METADATA);
    }

    @Override
    public void setNode(Node node) {
        this.setElement(node);
    }

    @Override
    public Node getNode() {
        return (Node)this.getElement();
    }

    public boolean isFullProperties() {
        Node node = this.getNode();
        NodeContainer container = node.getNodeContainer();
        while (!(container instanceof RuleFlowProcess)) {
            if (container instanceof Node) {
                container = ((Node)container).getNodeContainer();
                continue;
            }
            return false;
        }
        return !((RuleFlowProcess)container).isAutoComplete();
    }

    @Override
    public String getId() {
        long id = this.getNode().getId();
        return id == -1L ? null : String.valueOf(this.getNode().getId());
    }

    @Override
    public String getName() {
        return this.getNode().getName();
    }

    @Override
    public void internalSetName(String name) {
        this.getNode().setName(name);
        this.notifyListeners(4);
    }

    @Override
    public Color internalGetColor() {
        Integer rgb = (Integer)this.getNode().getMetaData().get("color");
        if (rgb != null) {
            return new Color((Device)Display.getCurrent(), AbstractNodeWrapper.integerToRGB(rgb));
        }
        return null;
    }

    @Override
    protected void internalSetColor(Integer color) {
        this.getNode().setMetaData("color", (Object)color);
    }

    @Override
    protected void internalSetConstraint(Rectangle constraint) {
        Node node = this.getNode();
        node.setMetaData("x", (Object)constraint.x);
        node.setMetaData("y", (Object)constraint.y);
        node.setMetaData("width", (Object)constraint.width);
        node.setMetaData("height", (Object)constraint.height);
    }

    @Override
    public Rectangle internalGetConstraint() {
        Node node = this.getNode();
        Integer x = (Integer)node.getMetaData().get("x");
        Integer y = (Integer)node.getMetaData().get("y");
        Integer width = (Integer)node.getMetaData().get("width");
        Integer height = (Integer)node.getMetaData().get("height");
        return new Rectangle(x == null ? 0 : x, y == null ? 0 : y, width == null ? -1 : width, height == null ? -1 : height);
    }

    @Override
    public boolean acceptsIncomingConnection(ElementConnection connection, ElementWrapper source) {
        return source == null || source.getParent() == this.getParent() || this.getParent() == source;
    }

    @Override
    public boolean acceptsOutgoingConnection(ElementConnection connection, ElementWrapper target) {
        return target == null || ((NodeWrapper)target).getNode().getNodeContainer() == this.getNode().getNodeContainer() || ((NodeWrapper)target).getNode() == this.getNode().getNodeContainer();
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return DESCRIPTORS;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (METADATA.equals(id)) {
            return ((NodeImpl)this.getNode()).getMetaData();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void resetPropertyValue(Object id) {
        if (METADATA.equals(id)) {
            ((NodeImpl)this.getNode()).setMetaData(new HashMap());
        } else {
            super.resetPropertyValue(id);
        }
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (METADATA.equals(id)) {
            ((NodeImpl)this.getNode()).setMetaData((Map)value);
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

