/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.core;

import java.util.ArrayList;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.ruleflow.core.AbstractNodeWrapper;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.EventNode;

public class EventNodeWrapper
extends AbstractNodeWrapper {
    private static final long serialVersionUID = 510L;
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[AbstractNodeWrapper.DESCRIPTORS.length + 2];
    public static final String VARIABLE_NAME = "variableName";
    public static final String EVENT_TYPE = "eventType";
    public static final String SCOPE = "scope";

    static {
        System.arraycopy(AbstractNodeWrapper.DESCRIPTORS, 0, descriptors, 0, AbstractNodeWrapper.DESCRIPTORS.length);
        EventNodeWrapper.descriptors[EventNodeWrapper.descriptors.length - 2] = new TextPropertyDescriptor((Object)VARIABLE_NAME, "VariableName");
        EventNodeWrapper.descriptors[EventNodeWrapper.descriptors.length - 1] = new TextPropertyDescriptor((Object)EVENT_TYPE, "EventType");
    }

    public EventNodeWrapper() {
        this.setNode((Node)new EventNode());
        this.setName("Event");
    }

    public EventNode getEventNode() {
        return (EventNode)this.getNode();
    }

    @Override
    public boolean acceptsIncomingConnection(ElementConnection connection, ElementWrapper source) {
        return super.acceptsIncomingConnection(connection, source) && this.getIncomingConnections().isEmpty();
    }

    @Override
    public boolean acceptsOutgoingConnection(ElementConnection connection, ElementWrapper target) {
        return super.acceptsOutgoingConnection(connection, target) && this.getOutgoingConnections().isEmpty();
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (VARIABLE_NAME.equals(id)) {
            String variableName = this.getEventNode().getVariableName();
            return variableName == null ? "" : variableName;
        }
        if (EVENT_TYPE.equals(id)) {
            if (this.getEventNode().getEventFilters().isEmpty()) {
                return "";
            }
            return ((EventTypeFilter)this.getEventNode().getEventFilters().get(0)).getType();
        }
        if (SCOPE.equals(id)) {
            return "external".equals(this.getEventNode().getScope()) ? 1 : 0;
        }
        return super.getPropertyValue(id);
    }

    @Override
    public void resetPropertyValue(Object id) {
        if (VARIABLE_NAME.equals(id)) {
            this.getEventNode().setVariableName(null);
        } else if (EVENT_TYPE.equals(id)) {
            this.getEventNode().setEventFilters(new ArrayList());
        } else if (SCOPE.equals(id)) {
            this.getEventNode().setScope("internal");
        } else {
            super.resetPropertyValue(id);
        }
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (VARIABLE_NAME.equals(id)) {
            this.getEventNode().setVariableName((String)value);
        } else if (EVENT_TYPE.equals(id)) {
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType((String)value);
            eventFilters.add(eventFilter);
            this.getEventNode().setEventFilters(eventFilters);
        } else if (SCOPE.equals(id)) {
            this.getEventNode().setScope((Integer)value == 1 ? "external" : "internal");
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

