/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.editor.editpart;

import org.drools.eclipse.flow.common.editor.core.ElementConnectionFactory;
import org.drools.eclipse.flow.common.editor.editpart.ElementConnectionEditPart;
import org.drools.eclipse.flow.ruleflow.core.ConnectionWrapper;
import org.drools.eclipse.flow.ruleflow.core.ConnectionWrapperFactory;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

public class ConnectionWrapperEditPart
extends ElementConnectionEditPart {
    private Label sourceLabel;

    @Override
    protected ElementConnectionFactory getDefaultElementConnectionFactory() {
        return new ConnectionWrapperFactory();
    }

    public ConnectionWrapper getConnectionWrapper() {
        return (ConnectionWrapper)this.getModel();
    }

    @Override
    protected IFigure createFigure() {
        Connection result = (Connection)super.createFigure();
        String label = (String)this.getConnectionWrapper().getConnection().getMetaData().get("label");
        if (label != null) {
            ConnectionEndpointLocator sourceEndpointLocator = new ConnectionEndpointLocator(result, true);
            sourceEndpointLocator.setVDistance(15);
            this.sourceLabel = new Label(label);
            result.add((IFigure)this.sourceLabel, (Object)sourceEndpointLocator);
        }
        return result;
    }

    @Override
    protected void refreshLabel() {
        super.refreshLabel();
        String label = (String)this.getConnectionWrapper().getConnection().getMetaData().get("label");
        if (this.sourceLabel != null) {
            this.sourceLabel.setText(label == null ? "" : label);
        } else if (label != null) {
            Connection connection = (Connection)this.getFigure();
            ConnectionEndpointLocator endpointLocator = new ConnectionEndpointLocator(connection, true);
            endpointLocator.setVDistance(15);
            this.sourceLabel = new Label(label);
            connection.add((IFigure)this.sourceLabel, (Object)endpointLocator);
        }
    }
}

