/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal;

import java.util.Properties;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactoryService;
import org.kie.internal.utils.ServiceRegistryImpl;

public class KnowledgeBaseFactory {
    private static KnowledgeBaseFactoryService factoryService;

    public static KnowledgeBase newKnowledgeBase() {
        return KnowledgeBaseFactory.getKnowledgeBaseFactoryService().newKnowledgeBase();
    }

    public static KnowledgeBase newKnowledgeBase(String kbaseId) {
        return KnowledgeBaseFactory.getKnowledgeBaseFactoryService().newKnowledgeBase(kbaseId);
    }

    public static KnowledgeBase newKnowledgeBase(KieBaseConfiguration conf) {
        return KnowledgeBaseFactory.getKnowledgeBaseFactoryService().newKnowledgeBase(conf);
    }

    public static KnowledgeBase newKnowledgeBase(String kbaseId, KieBaseConfiguration conf) {
        return KnowledgeBaseFactory.getKnowledgeBaseFactoryService().newKnowledgeBase(kbaseId, conf);
    }

    public static KieBaseConfiguration newKnowledgeBaseConfiguration() {
        return KnowledgeBaseFactory.getKnowledgeBaseFactoryService().newKnowledgeBaseConfiguration();
    }

    public static KieBaseConfiguration newKnowledgeBaseConfiguration(Properties properties, ClassLoader ... classLoaders) {
        return KnowledgeBaseFactory.getKnowledgeBaseFactoryService().newKnowledgeBaseConfiguration(properties, classLoaders);
    }

    public static KieSessionConfiguration newKnowledgeSessionConfiguration() {
        return KnowledgeBaseFactory.getKnowledgeBaseFactoryService().newKnowledgeSessionConfiguration();
    }

    public static KieSessionConfiguration newKnowledgeSessionConfiguration(Properties properties) {
        return KnowledgeBaseFactory.getKnowledgeBaseFactoryService().newKnowledgeSessionConfiguration(properties);
    }

    public static Environment newEnvironment() {
        return KnowledgeBaseFactory.getKnowledgeBaseFactoryService().newEnvironment();
    }

    public static synchronized void setKnowledgeBaseServiceFactory(KnowledgeBaseFactoryService serviceFactory) {
        factoryService = serviceFactory;
    }

    private static synchronized KnowledgeBaseFactoryService getKnowledgeBaseFactoryService() {
        if (factoryService == null) {
            KnowledgeBaseFactory.loadServiceFactory();
        }
        return factoryService;
    }

    private static void loadServiceFactory() {
        KnowledgeBaseFactory.setKnowledgeBaseServiceFactory(ServiceRegistryImpl.getInstance().get(KnowledgeBaseFactoryService.class));
    }
}

