/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

public abstract class AbstractExceptionHandlingTaskHandler
implements WorkItemHandler {
    private WorkItemHandler originalTaskHandler;

    public AbstractExceptionHandlingTaskHandler(WorkItemHandler originalTaskHandler) {
        this.originalTaskHandler = originalTaskHandler;
        this.unsetLoggingInHandler(originalTaskHandler);
    }

    public AbstractExceptionHandlingTaskHandler(Class<? extends WorkItemHandler> originalTaskHandlerClass) {
        Class[] clsParams = new Class[]{};
        Object[] objParams = new Object[]{};
        try {
            this.originalTaskHandler = originalTaskHandlerClass.getConstructor(clsParams).newInstance(objParams);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("The " + WorkItemHandler.class.getSimpleName() + " parameter must have a public no-argument constructor.");
        }
        this.unsetLoggingInHandler(this.originalTaskHandler);
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            this.originalTaskHandler.executeWorkItem(workItem, manager);
        }
        catch (Throwable cause) {
            this.handleExecuteException(cause, workItem, manager);
        }
    }

    private void unsetLoggingInHandler(WorkItemHandler originalTaskHandler) {
        if (originalTaskHandler instanceof ServiceTaskHandler) {
            ((ServiceTaskHandler)originalTaskHandler).setLogThrownException(false);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            this.originalTaskHandler.abortWorkItem(workItem, manager);
        }
        catch (RuntimeException re) {
            this.handleAbortException(re, workItem, manager);
        }
    }

    public WorkItemHandler getOriginalTaskHandler() {
        return this.originalTaskHandler;
    }

    public abstract void handleExecuteException(Throwable var1, WorkItem var2, WorkItemManager var3);

    public abstract void handleAbortException(Throwable var1, WorkItem var2, WorkItemManager var3);
}

