/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.kie.api.definition.process.Connection;
import org.xml.sax.Attributes;

public class CompositeContextNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        throw new IllegalArgumentException("Reading in should be handled by end event handler");
    }

    public Class generateNodeFor() {
        return CompositeContextNode.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        CompositeContextNode compositeNode = (CompositeContextNode)node;
        String nodeType = "subProcess";
        if (node.getMetaData().get("Transaction") != null) {
            nodeType = "transaction";
        }
        this.writeNode(nodeType, (Node)compositeNode, xmlDump, metaDataType);
        if (compositeNode instanceof EventSubProcessNode) {
            xmlDump.append(" triggeredByEvent=\"true\" ");
        }
        if (((Boolean)compositeNode.getMetaData("isForCompensation")).booleanValue()) {
            xmlDump.append("isForCompensation=\"true\" ");
        }
        xmlDump.append(" >" + EOL);
        VariableScope variableScope = (VariableScope)compositeNode.getDefaultContext("VariableScope");
        if (variableScope != null && !variableScope.getVariables().isEmpty()) {
            xmlDump.append("    <!-- variables -->" + EOL);
            for (Variable variable : variableScope.getVariables()) {
                xmlDump.append("    <property id=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(variable.getName()) + "\" ");
                if (variable.getType() != null) {
                    xmlDump.append("itemSubjectRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)compositeNode) + "-" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(variable.getName()) + "Item\"");
                }
                xmlDump.append("/>" + EOL);
            }
        }
        List<Node> subNodes = this.getSubNodes((CompositeNode)compositeNode);
        xmlDump.append("    <!-- nodes -->" + EOL);
        for (Node subNode : subNodes) {
            XmlBPMNProcessDumper.INSTANCE.visitNode((org.kie.api.definition.process.Node)subNode, xmlDump, metaDataType);
        }
        List<Connection> connections = this.getSubConnections((CompositeNode)compositeNode);
        xmlDump.append("    <!-- connections -->" + EOL);
        for (Connection connection : connections) {
            XmlBPMNProcessDumper.INSTANCE.visitConnection(connection, xmlDump, metaDataType);
        }
        this.endNode(nodeType, xmlDump);
    }

    protected List<Node> getSubNodes(CompositeNode compositeNode) {
        ArrayList<Node> subNodes = new ArrayList<Node>();
        for (org.kie.api.definition.process.Node subNode : compositeNode.getNodes()) {
            if (subNode instanceof CompositeNode.CompositeNodeStart || subNode instanceof CompositeNode.CompositeNodeEnd) continue;
            subNodes.add((Node)subNode);
        }
        return subNodes;
    }

    protected List<Connection> getSubConnections(CompositeNode compositeNode) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (org.kie.api.definition.process.Node subNode : compositeNode.getNodes()) {
            if (subNode instanceof CompositeNode.CompositeNodeEnd) continue;
            for (Connection connection : subNode.getIncomingConnections("DROOLS_DEFAULT")) {
                if (connection.getFrom() instanceof CompositeNode.CompositeNodeStart) continue;
                connections.add(connection);
            }
        }
        return connections;
    }
}

