/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.Map;
import org.drools.compiler.compiler.xml.XmlDumper;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.xml.sax.Attributes;

public class WorkItemNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        throw new IllegalArgumentException("Reading in should be handled by specific handlers");
    }

    public Class generateNodeFor() {
        return WorkItemNode.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        WorkItemNode workItemNode = (WorkItemNode)node;
        String type = workItemNode.getWork().getName();
        if ("Manual Task".equals(type)) {
            this.writeNode("manualTask", (Node)workItemNode, xmlDump, metaDataType);
            xmlDump.append(">" + EOL);
            this.writeScripts((ExtendedNodeImpl)workItemNode, xmlDump);
            this.endNode("manualTask", xmlDump);
            return;
        }
        if ("Service Task".equals(type)) {
            String outMapping;
            this.writeNode("serviceTask", (Node)workItemNode, xmlDump, metaDataType);
            xmlDump.append("operationRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_ServiceOperation\" implementation=\"Other\" >" + EOL);
            this.writeScripts((ExtendedNodeImpl)workItemNode, xmlDump);
            xmlDump.append("      <ioSpecification>" + EOL + "        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_param\" name=\"Parameter\" />" + EOL + "        <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_result\" name=\"Result\" />" + EOL + "        <inputSet>" + EOL + "          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_param</dataInputRefs>" + EOL + "        </inputSet>" + EOL + "        <outputSet>" + EOL + "          <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_result</dataOutputRefs>" + EOL + "        </outputSet>" + EOL + "      </ioSpecification>" + EOL);
            String inMapping = workItemNode.getInMapping("Parameter");
            if (inMapping != null) {
                xmlDump.append("      <dataInputAssociation>" + EOL + "        <sourceRef>" + XmlDumper.replaceIllegalChars((String)inMapping) + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_param</targetRef>" + EOL + "      </dataInputAssociation>" + EOL);
            }
            if ((outMapping = workItemNode.getOutMapping("Result")) != null) {
                xmlDump.append("      <dataOutputAssociation>" + EOL + "        <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_result</sourceRef>" + EOL + "        <targetRef>" + XmlDumper.replaceIllegalChars((String)outMapping) + "</targetRef>" + EOL + "      </dataOutputAssociation>" + EOL);
            }
            this.endNode("serviceTask", xmlDump);
            return;
        }
        if ("Send Task".equals(type)) {
            this.writeNode("sendTask", (Node)workItemNode, xmlDump, metaDataType);
            xmlDump.append("messageRef=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_Message\" implementation=\"Other\" >" + EOL);
            this.writeScripts((ExtendedNodeImpl)workItemNode, xmlDump);
            xmlDump.append("      <ioSpecification>" + EOL + "        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_param\" name=\"Message\" />" + EOL + "        <inputSet>" + EOL + "          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_param</dataInputRefs>" + EOL + "        </inputSet>" + EOL + "        <outputSet/>" + EOL + "      </ioSpecification>" + EOL);
            String inMapping = workItemNode.getInMapping("Message");
            if (inMapping != null) {
                xmlDump.append("      <dataInputAssociation>" + EOL + "        <sourceRef>" + XmlDumper.replaceIllegalChars((String)inMapping) + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_param</targetRef>" + EOL + "      </dataInputAssociation>" + EOL);
            }
            this.endNode("sendTask", xmlDump);
            return;
        }
        if ("Receive Task".equals(type)) {
            this.writeNode("receiveTask", (Node)workItemNode, xmlDump, metaDataType);
            String messageId = (String)workItemNode.getWork().getParameter("MessageId");
            xmlDump.append("messageRef=\"" + messageId + "\" implementation=\"Other\" >" + EOL);
            this.writeScripts((ExtendedNodeImpl)workItemNode, xmlDump);
            xmlDump.append("      <ioSpecification>" + EOL + "        <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_result\" name=\"Message\" />" + EOL + "        <inputSet/>" + EOL + "        <outputSet>" + EOL + "          <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_result</dataOutputRefs>" + EOL + "        </outputSet>" + EOL + "      </ioSpecification>" + EOL);
            String outMapping = workItemNode.getOutMapping("Message");
            if (outMapping != null) {
                xmlDump.append("      <dataOutputAssociation>" + EOL + "        <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_result</sourceRef>" + EOL + "        <targetRef>" + XmlDumper.replaceIllegalChars((String)outMapping) + "</targetRef>" + EOL + "      </dataOutputAssociation>" + EOL);
            }
            this.endNode("receiveTask", xmlDump);
            return;
        }
        this.writeNode("task", (Node)workItemNode, xmlDump, metaDataType);
        if (((Boolean)workItemNode.getMetaData("isForCompensation")).booleanValue()) {
            xmlDump.append("isForCompensation=\"true\" ");
        }
        xmlDump.append("tns:taskName=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\" >" + EOL);
        this.writeScripts((ExtendedNodeImpl)workItemNode, xmlDump);
        this.writeIO(workItemNode, xmlDump);
        this.endNode("task", xmlDump);
    }

    protected void writeIO(WorkItemNode workItemNode, StringBuilder xmlDump) {
        xmlDump.append("      <ioSpecification>" + EOL);
        for (Map.Entry entry : workItemNode.getInMappings().entrySet()) {
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : workItemNode.getWork().getParameters().entrySet()) {
            if (entry.getValue() == null) continue;
            xmlDump.append("        <dataInput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        for (Map.Entry entry : workItemNode.getOutMappings().entrySet()) {
            xmlDump.append("        <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Output\" name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "\" />" + EOL);
        }
        xmlDump.append("        <inputSet>" + EOL);
        for (Map.Entry entry : workItemNode.getInMappings().entrySet()) {
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute((String)entry.getKey()) + "Input</dataInputRefs>" + EOL);
        }
        for (Map.Entry entry : workItemNode.getWork().getParameters().entrySet()) {
            if (entry.getValue() == null) continue;
            xmlDump.append("          <dataInputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</dataInputRefs>" + EOL);
        }
        xmlDump.append("        </inputSet>" + EOL);
        xmlDump.append("        <outputSet>" + EOL);
        for (Map.Entry entry : workItemNode.getOutMappings().entrySet()) {
            xmlDump.append("          <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</dataOutputRefs>" + EOL);
        }
        xmlDump.append("        </outputSet>" + EOL);
        xmlDump.append("      </ioSpecification>" + EOL);
        this.writeInputAssociation(workItemNode, xmlDump);
        this.writeOutputAssociation(workItemNode, xmlDump);
    }

    protected void writeInputAssociation(WorkItemNode workItemNode, StringBuilder xmlDump) {
        for (Map.Entry entry : workItemNode.getInMappings().entrySet()) {
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</sourceRef>" + EOL + "        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (Map.Entry entry : workItemNode.getWork().getParameters().entrySet()) {
            if (entry.getValue() == null) continue;
            xmlDump.append("      <dataInputAssociation>" + EOL);
            xmlDump.append("        <targetRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</targetRef>" + EOL + "        <assignment>" + EOL + "          <from xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)entry.getValue().toString()) + "</from>" + EOL + "          <to xsi:type=\"tFormalExpression\">" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Input</to>" + EOL + "        </assignment>" + EOL);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
    }

    protected void writeOutputAssociation(WorkItemNode workItemNode, StringBuilder xmlDump) {
        for (Map.Entry entry : workItemNode.getOutMappings().entrySet()) {
            xmlDump.append("      <dataOutputAssociation>" + EOL);
            xmlDump.append("        <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((org.kie.api.definition.process.Node)workItemNode) + "_" + XmlDumper.replaceIllegalChars((String)((String)entry.getKey())) + "Output</sourceRef>" + EOL + "        <targetRef>" + XmlDumper.replaceIllegalChars((String)((String)entry.getValue())) + "</targetRef>" + EOL);
            xmlDump.append("      </dataOutputAssociation>" + EOL);
        }
    }
}

