/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.internal.io.ResourceTypeImpl;

public class KieFileSystemImpl
implements KieFileSystem {
    private final MemoryFileSystem mfs;

    public KieFileSystemImpl() {
        this(new MemoryFileSystem());
    }

    public KieFileSystemImpl(MemoryFileSystem mfs) {
        this.mfs = mfs;
    }

    public KieFileSystem write(String path, byte[] content) {
        this.mfs.write(path, content, true);
        return this;
    }

    public KieFileSystem write(String path, String text) {
        return this.write(path, text.getBytes());
    }

    public KieFileSystem write(String path, Resource resource) {
        try {
            return this.write(path, IoUtils.readBytesFromInputStream((InputStream)resource.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write Resource: " + resource.toString(), e);
        }
    }

    public KieFileSystem write(Resource resource) {
        try {
            String target;
            String string = target = resource.getTargetPath() != null ? resource.getTargetPath() : resource.getSourcePath();
            if (target != null) {
                this.write(KieBuilderImpl.RESOURCES_ROOT + target, IoUtils.readBytesFromInputStream((InputStream)resource.getInputStream()));
                ResourceConfiguration conf = resource.getConfiguration();
                if (conf != null) {
                    Properties prop = ResourceTypeImpl.toProperties((ResourceConfiguration)conf);
                    ByteArrayOutputStream buff = new ByteArrayOutputStream();
                    prop.store(buff, "Configuration properties for resource: " + target);
                    this.write(KieBuilderImpl.RESOURCES_ROOT + target + ".properties", buff.toByteArray());
                }
                return this;
            }
            throw new RuntimeException("Resource does not have neither a source nor a target path. Impossible to add it to the bundle. Please set either the source or target name of the resource before adding it." + resource.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write Resource: " + resource.toString(), e);
        }
    }

    public void delete(String ... paths) {
        for (String path : paths) {
            this.mfs.remove(path);
        }
    }

    public byte[] read(String path) {
        return this.mfs.read(path);
    }

    public MemoryFileSystem asMemoryFileSystem() {
        return this.mfs;
    }

    public KieFileSystem generateAndWritePomXML(ReleaseId releaseId) {
        this.write("pom.xml", KieBuilderImpl.generatePomXml(releaseId));
        return this;
    }

    public KieFileSystem writePomXML(byte[] content) {
        this.write("pom.xml", content);
        return this;
    }

    public KieFileSystem writePomXML(String content) {
        this.write("pom.xml", content);
        return this;
    }

    public KieFileSystem writeKModuleXML(byte[] content) {
        this.write(KieModuleModelImpl.KMODULE_SRC_PATH, content);
        return this;
    }

    public KieFileSystem writeKModuleXML(String content) {
        this.write(KieModuleModelImpl.KMODULE_SRC_PATH, content);
        return this;
    }
}

