/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.client;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.ILocator;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.AbstractResourceHandle;
import org.eclipse.webdav.client.DAVClient;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.client.PropertyStatus;
import org.eclipse.webdav.client.ResourceHandle;
import org.eclipse.webdav.client.URLTable;
import org.eclipse.webdav.client.WorkspaceHandle;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.internal.kernel.DAVException;
import org.eclipse.webdav.internal.kernel.SystemException;
import org.eclipse.webdav.internal.kernel.utils.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CollectionHandle
extends AbstractResourceHandle {
    public CollectionHandle(DAVClient davClient, ILocator locator) {
        super(davClient, locator);
    }

    public void baselineControl() throws DAVException {
        IResponse response = null;
        try {
            try {
                response = this.davClient.baselineControl(this.locator, this.newContext(), null);
                this.examineResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
        this.closeResponse(response);
    }

    public void baselineControl(ILocator baseline) throws DAVException {
        Assert.isNotNull(baseline);
        Document document = this.newDocument();
        Element root = ElementEditor.create(document, "baseline-control");
        ElementEditor.addChild(root, "baseline", baseline.getResourceURL(), new String[]{"baseline"}, true);
        IResponse response = null;
        try {
            try {
                response = this.davClient.baselineControl(this.locator, this.newContext(), document);
                this.examineResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
        this.closeResponse(response);
    }

    public void bind(String member, ILocator source) throws DAVException {
        this.bind(member, source, false);
    }

    public void bind(String member, ILocator source, boolean overwrite) throws DAVException {
        IContext context = this.newContext();
        context.setOverwrite(overwrite);
        ILocator destination = this.getMember(member);
        IResponse response = null;
        try {
            try {
                response = this.davClient.bind(source, destination, context);
                this.examineResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
        this.closeResponse(response);
    }

    @Override
    public AbstractResourceHandle checkOut() throws DAVException {
        ILocator locator = this.protectedCheckOut();
        return new CollectionHandle(this.davClient, locator);
    }

    @Override
    public void create() throws DAVException {
        IResponse response = null;
        try {
            try {
                response = this.davClient.mkcol(this.locator, this.newContext(), null);
                this.examineResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable throwable) {
            this.closeResponse(response);
            throw throwable;
        }
        this.closeResponse(response);
    }

    public void mkdirs() throws DAVException {
        this.mkdirs(this);
    }

    /*
     * Unable to fully structure code
     */
    protected void mkdirs(CollectionHandle handle) throws DAVException {
        block7: {
            response = null;
            response = this.davClient.mkcol(handle.locator, this.newContext(), null);
            status = response.getStatusCode();
            if (status != 405 || !handle.isCollection()) break block7;
            while (true) {
                this.closeResponse(response);
                return;
            }
        }
        try {
            try {
                if (status == 403 && handle.isCollection() && handle.exists()) ** continue;
                if (status == 409) {
                    this.closeResponse(response);
                    parent = handle.getParent();
                    this.mkdirs(parent);
                    response = this.davClient.mkcol(handle.locator, this.newContext(), null);
                }
                this.examineResponse(response);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        catch (Throwable var5_6) {
            this.closeResponse(response);
            throw var5_6;
        }
        this.closeResponse(response);
    }

    public CollectionHandle getCollectionHandle(String name) throws DAVException {
        return new CollectionHandle(this.davClient, this.getMember(name));
    }

    public ILocator getMember(String memberName) {
        Assert.isTrue(this.locator.getLabel() == null);
        Assert.isTrue(!this.locator.isStable());
        String parentName = this.locator.getResourceURL();
        String childName = parentName.endsWith("/") ? String.valueOf(parentName) + memberName : String.valueOf(parentName) + "/" + memberName;
        return this.davClient.getDAVFactory().newLocator(childName);
    }

    public Set getMembers() throws DAVException {
        Vector<QualifiedName> querySet = new Vector<QualifiedName>();
        querySet.add(DAV_RESOURCE_TYPE);
        URLTable resourceTable = this.getProperties(querySet, "1");
        HashSet<AbstractResourceHandle> reply = new HashSet<AbstractResourceHandle>();
        try {
            resourceTable.remove(this.locator.getResourceURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw new DAVException(Policy.bind("exception.malformedLocator"));
        }
        Enumeration resourceNameEnum = resourceTable.keys();
        while (resourceNameEnum.hasMoreElements()) {
            URL url = (URL)resourceNameEnum.nextElement();
            Hashtable propertyTable = (Hashtable)resourceTable.get(url);
            Assert.isNotNull(propertyTable);
            PropertyStatus propertyStatus = (PropertyStatus)propertyTable.get(DAV_RESOURCE_TYPE);
            Assert.isNotNull(propertyStatus);
            ILocator newLocator = this.davClient.getDAVFactory().newLocator(url.toString());
            Element property = propertyStatus.getProperty();
            try {
                if (ElementEditor.hasChild(property, DAV_COLLECTION_RESOURCE_TYPE)) {
                    reply.add(new CollectionHandle(this.davClient, newLocator));
                    continue;
                }
                reply.add(new ResourceHandle(this.davClient, newLocator));
            }
            catch (MalformedElementException exception) {
                throw new SystemException(exception);
            }
        }
        return reply;
    }

    public ResourceHandle getResourceHandle(String name) throws DAVException {
        return new ResourceHandle(this.davClient, this.getMember(name));
    }

    public WorkspaceHandle getWorkspaceHandle(String name) throws DAVException {
        return new WorkspaceHandle(this.davClient, this.getMember(name));
    }

    public boolean isWorkspace() throws DAVException {
        return this.supportsLiveProperty(DAV_WORKSPACE_CHECKOUT_SET);
    }
}

