/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.client.Policy;
import org.eclipse.webdav.http.client.IAuthenticator;
import org.eclipse.webdav.http.client.Request;
import org.eclipse.webdav.internal.authentication.AuthenticateChallenge;
import org.eclipse.webdav.internal.authentication.AuthenticationInfo;
import org.eclipse.webdav.internal.authentication.AuthorizationAuthority;
import org.eclipse.webdav.internal.authentication.HexConverter;
import org.eclipse.webdav.internal.authentication.Parser;
import org.eclipse.webdav.internal.authentication.ParserException;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class DigestAuthority
extends AuthorizationAuthority {
    public DigestAuthority(IAuthenticator authenticatorStore) {
        super(authenticatorStore);
    }

    @Override
    protected boolean confirmResponse(Request request, IResponse response, URL proxyServerUrl) {
        Assert.isNotNull(request);
        Assert.isNotNull(response);
        String authInfoString = response.getContext().get("Authentication-Info");
        if (authInfoString == null) {
            return false;
        }
        AuthenticationInfo authInfo = null;
        try {
            authInfo = new AuthenticationInfo(authInfoString);
        }
        catch (ParserException parserException) {
            return false;
        }
        String nextNonce = authInfo.getNextNonce();
        String messageQop = authInfo.getMessageQop();
        String responseAuth = authInfo.getResponseAuth();
        String cnonce = authInfo.getCNonce();
        String nonceCount = authInfo.getNonceCount();
        URL resourceUrl = request.getResourceUrl();
        URL serverUrl = null;
        try {
            serverUrl = new URL(resourceUrl.getProtocol(), resourceUrl.getHost(), resourceUrl.getPort(), "/");
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        String realm = this.authenticatorStore.getProtectionSpace(resourceUrl);
        if (realm == null) {
            return false;
        }
        Map info = this.authenticatorStore.getAuthenticationInfo(serverUrl, realm, "Digest");
        if (info == null) {
            return false;
        }
        String username = (String)info.get("username");
        String password = (String)info.get("password");
        String algorithm = (String)info.get("algorithm");
        String nonce = (String)info.get("nonce");
        String iNonceCount = (String)info.get("nc");
        String iCnonce = (String)info.get("cnonce");
        if (username == null || password == null || nonce == null) {
            return false;
        }
        if (cnonce != null && !cnonce.equals(iCnonce)) {
            return false;
        }
        if (nonceCount != null && !nonceCount.equals(iNonceCount)) {
            return false;
        }
        if (responseAuth != null) {
            try {
                String iResponseAuth;
                String digestUri = resourceUrl.toString();
                if (proxyServerUrl == null) {
                    digestUri = resourceUrl.getFile();
                    String ref = resourceUrl.getRef();
                    if (ref != null) {
                        digestUri = String.valueOf(digestUri) + "#" + ref;
                    }
                }
                if (!responseAuth.equals(iResponseAuth = this.response(request, realm, username, password, algorithm, messageQop, nonce, nonceCount, cnonce, request.getMethod(), digestUri))) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        info.put("nonce", nextNonce);
        return true;
    }

    private String credentials(Request request, String realm, String username, String password, String algorithm, String messageQop, String nonce, String nonceCount, String opaque, String cnonce, String method, String digestUri) throws Exception {
        String response;
        Assert.isNotNull(request);
        Assert.isNotNull(realm);
        Assert.isNotNull(username);
        Assert.isNotNull(password);
        Assert.isNotNull(nonce);
        Assert.isNotNull(method);
        Assert.isNotNull(digestUri);
        StringBuffer buf = new StringBuffer();
        buf.append("Digest username=\"");
        buf.append(username);
        buf.append("\"");
        buf.append(", realm=");
        buf.append(realm);
        if (messageQop != null) {
            buf.append(", qop=\"");
            buf.append(messageQop);
            buf.append("\"");
        }
        if (algorithm != null) {
            buf.append(", algorithm=");
            buf.append(algorithm);
        }
        buf.append(", uri=\"");
        buf.append(digestUri);
        buf.append("\"");
        buf.append(", nonce=");
        buf.append(nonce);
        if (nonceCount != null) {
            buf.append(", nc=");
            buf.append(nonceCount);
        }
        if (cnonce != null) {
            buf.append(", cnonce=\"");
            buf.append(cnonce);
            buf.append("\"");
        }
        if (opaque != null) {
            buf.append(", opaque=");
            buf.append(opaque);
        }
        if ((response = this.response(request, realm, username, password, algorithm, messageQop, nonce, nonceCount, cnonce, method, digestUri)) == null) {
            return null;
        }
        buf.append(", response=\"");
        buf.append(response);
        buf.append("\"");
        return buf.toString();
    }

    @Override
    protected Map getAuthenticationInfo(AuthenticateChallenge challenge, Map oldInfo, URL serverUrl, URL protectionSpaceUrl) {
        String qop;
        String algorithm;
        String nonce;
        Assert.isNotNull(challenge);
        Assert.isNotNull(serverUrl);
        Assert.isNotNull(protectionSpaceUrl);
        Hashtable info = new Hashtable(5);
        String stale = challenge.get("stale");
        if (oldInfo == null || stale == null || !Boolean.valueOf(stale).booleanValue()) {
            Map userpass = this.authenticatorStore.requestAuthenticationInfo(protectionSpaceUrl, challenge.getRealm(), challenge.getAuthScheme());
            if (userpass == null) {
                return null;
            }
            info.put("username", userpass.get("username"));
            info.put("password", userpass.get("password"));
        } else {
            info.put("username", oldInfo.get("username"));
            info.put("password", oldInfo.get("password"));
        }
        String realm = challenge.getRealm();
        String domain = challenge.get("domain");
        boolean addRoot = true;
        if (domain != null && domain.charAt(0) == '\"' && domain.charAt(domain.length() - 1) == '\"') {
            int start = 1;
            boolean inSpace = false;
            int i = 1;
            while (i < domain.length()) {
                if (Character.isWhitespace(domain.charAt(i)) || i == domain.length() - 1) {
                    if (!inSpace) {
                        inSpace = true;
                        String urlString = domain.substring(start, i);
                        URL url = null;
                        try {
                            url = new URL(urlString);
                        }
                        catch (MalformedURLException malformedURLException) {
                            try {
                                url = new URL(serverUrl, urlString);
                            }
                            catch (MalformedURLException malformedURLException2) {}
                        }
                        if (url != null) {
                            this.authenticatorStore.addProtectionSpace(url, realm);
                            addRoot = false;
                        }
                    }
                } else if (inSpace) {
                    inSpace = false;
                    start = i;
                }
                ++i;
            }
        }
        if (addRoot) {
            this.authenticatorStore.addProtectionSpace(serverUrl, realm);
        }
        if ((nonce = challenge.get("nonce")) == null) {
            return null;
        }
        info.put("nonce", nonce);
        String opaque = challenge.get("opaque");
        if (opaque != null) {
            info.put("opaque", opaque);
        }
        if ((algorithm = challenge.get("algorithm")) != null) {
            info.put("algorithm", algorithm);
        }
        if ((qop = challenge.get("qop")) != null && qop.charAt(0) == '\"' && qop.charAt(qop.length() - 1) == '\"') {
            boolean foundAuth = false;
            boolean foundAuthInt = false;
            try {
                String token = null;
                boolean first = true;
                Parser parser = new Parser(qop.substring(1, qop.length() - 1));
                while (parser.pos < parser.s.length()) {
                    if (first) {
                        parser.skipWhiteSpace();
                        first = false;
                    } else {
                        parser.match(',');
                        parser.skipWhiteSpace();
                    }
                    token = parser.nextToken();
                    if (token.equalsIgnoreCase("auth")) {
                        foundAuth = true;
                    } else if (token.equalsIgnoreCase("auth-int")) {
                        foundAuthInt = true;
                    }
                    parser.skipWhiteSpace();
                }
            }
            catch (ParserException parserException) {}
            if (foundAuthInt) {
                info.put("qop", "auth-int");
            } else if (foundAuth) {
                info.put("qop", "auth");
            }
        }
        return info;
    }

    @Override
    protected String getAuthorization(Request request, Map info, URL serverUrl, URL protectionSpaceUrl, URL proxyServerUrl) {
        String realm;
        Assert.isNotNull(request);
        Assert.isNotNull(info);
        Assert.isNotNull(serverUrl);
        Assert.isNotNull(protectionSpaceUrl);
        String username = (String)info.get("username");
        String password = (String)info.get("password");
        String algorithm = (String)info.get("algorithm");
        String messageQop = (String)info.get("qop");
        String nonce = (String)info.get("nonce");
        String nonceCount = (String)info.get("nc");
        String opaque = (String)info.get("opaque");
        String cnonce = null;
        if (username == null || password == null || nonce == null) {
            return null;
        }
        if (messageQop != null) {
            if (nonceCount == null) {
                nonceCount = "00000001";
            } else {
                int nc = Integer.parseInt(nonceCount, 16) + 1;
                nonceCount = HexConverter.toHex(new int[]{nc});
            }
            info.put("nc", nonceCount);
            long milliseconds = new Date().getTime();
            SecureRandom random = new SecureRandom();
            random.setSeed(milliseconds);
            byte[] bytes = new byte[16];
            random.nextBytes(bytes);
            cnonce = HexConverter.toHex(bytes);
            info.put("cnonce", cnonce);
        }
        if ((realm = this.authenticatorStore.getProtectionSpace(protectionSpaceUrl)) == null) {
            return null;
        }
        String method = request.getMethod();
        URL resourceUrl = request.getResourceUrl();
        String digestUri = resourceUrl.toString();
        if (proxyServerUrl != null) {
            digestUri = resourceUrl.getFile();
            String ref = resourceUrl.getRef();
            if (ref != null) {
                digestUri = String.valueOf(digestUri) + "#" + ref;
            }
        }
        try {
            return this.credentials(request, realm, username, password, algorithm, messageQop, nonce, nonceCount, opaque, cnonce, method, digestUri);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String ha1(String realm, String username, String password, String algorithm, String nonce, String cnonce) throws Exception {
        Assert.isNotNull(realm);
        Assert.isNotNull(username);
        Assert.isNotNull(password);
        Assert.isNotNull(nonce);
        String ha1 = this.md5(String.valueOf(this.unquote(username)) + ":" + this.unquote(realm) + ":" + password);
        if (algorithm != null && !algorithm.equalsIgnoreCase("MD5")) {
            if (algorithm.equalsIgnoreCase("MD5-sess")) {
                if (cnonce == null) {
                    return null;
                }
                ha1 = this.md5(String.valueOf(ha1) + ":" + this.unquote(nonce) + ":" + this.unquote(cnonce));
            } else {
                throw new Exception(Policy.bind("exception.unregognizedAlgo", algorithm));
            }
        }
        return ha1;
    }

    private String ha2(Request request, String qop, String method, String digestUri) throws Exception {
        Assert.isNotNull(request);
        Assert.isNotNull(method);
        Assert.isNotNull(digestUri);
        String a2 = null;
        if (qop == null || qop.equalsIgnoreCase("auth")) {
            a2 = this.md5(String.valueOf(method == null ? "" : method) + ":" + digestUri);
        } else if (qop.equalsIgnoreCase("auth-int")) {
            a2 = this.md5(String.valueOf(method == null ? "" : method) + ":" + digestUri + this.md5(request));
        } else {
            throw new Exception(Policy.bind("exception.unregognizedQop", qop));
        }
        return a2;
    }

    private String response(Request request, String realm, String username, String password, String algorithm, String qop, String nonce, String nonceCount, String cnonce, String method, String digestUri) throws Exception {
        Assert.isNotNull(request);
        Assert.isNotNull(realm);
        Assert.isNotNull(username);
        Assert.isNotNull(password);
        Assert.isNotNull(nonce);
        Assert.isNotNull(method);
        Assert.isNotNull(digestUri);
        String ha1 = this.ha1(realm, username, password, algorithm, nonce, cnonce);
        if (ha1 == null) {
            return null;
        }
        String ha2 = this.ha2(request, qop, method, digestUri);
        if (ha2 == null) {
            return null;
        }
        if (qop == null) {
            return this.md5(String.valueOf(ha1) + ":" + this.unquote(nonce) + ":" + ha2);
        }
        if (nonceCount == null || cnonce == null || qop == null) {
            return null;
        }
        return this.md5(String.valueOf(ha1) + ":" + this.unquote(nonce) + ":" + nonceCount + ":" + this.unquote(cnonce) + ":" + this.unquote(qop) + ":" + ha2);
    }
}

