/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.webdav.internal.kernel.ConditionFactor;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.WebDAVException;

public class ConditionTerm {
    private Vector conditionFactors = new Vector();

    public void addConditionFactor(ConditionFactor factor) throws WebDAVException {
        if (this.conditionFactors.contains(factor)) {
            throw new WebDAVException(400, Policy.bind("error.parseDuplicateEntry"));
        }
        this.conditionFactors.addElement(factor);
    }

    public boolean contains(ConditionFactor factor) {
        return this.conditionFactors.contains(factor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConditionTerm create(StreamTokenizer tokenizer) throws WebDAVException {
        ConditionTerm term = new ConditionTerm();
        try {
            int token = tokenizer.ttype;
            if (token != 40) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(token), "("));
            }
            token = tokenizer.nextToken();
            while (true) {
                if (token != -3 && token != 60 && token != 91) {
                    if (token != 41) {
                        throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(token), ")"));
                    }
                    token = tokenizer.nextToken();
                    break;
                }
                term.addConditionFactor(ConditionFactor.create(tokenizer));
                token = tokenizer.ttype;
            }
        }
        catch (IOException iOException) {}
        if (!term.getConditionFactors().hasMoreElements()) {
            throw new WebDAVException(400, Policy.bind("error.parseMissingStateOrEntity"));
        }
        return term;
    }

    public Enumeration getConditionFactors() {
        return this.conditionFactors.elements();
    }

    public boolean matches(ConditionTerm conditionTerm) {
        int numberOfItemsToMatch = 0;
        boolean match = true;
        Enumeration factors = this.getConditionFactors();
        while (match && factors.hasMoreElements()) {
            ConditionFactor factor = (ConditionFactor)factors.nextElement();
            if (factor.not()) {
                match = !conditionTerm.contains(factor);
                continue;
            }
            match = conditionTerm.contains(factor);
            ++numberOfItemsToMatch;
        }
        match = match && numberOfItemsToMatch == conditionTerm.numberOfFactors();
        return match;
    }

    public int numberOfFactors() {
        return this.conditionFactors.size();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        Enumeration factors = this.getConditionFactors();
        while (factors.hasMoreElements()) {
            ConditionFactor factor = (ConditionFactor)factors.nextElement();
            buffer.append(factor.toString());
            if (!factors.hasMoreElements()) continue;
            buffer.append(' ');
        }
        buffer.append(')');
        return buffer.toString();
    }
}

