/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.eclipse.webdav.internal.kernel.ConditionFactor;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.WebDAVException;

public class StateToken
extends ConditionFactor {
    private String uri = null;

    private StateToken() {
    }

    public StateToken(String uri) {
        this.uri = uri;
    }

    public static ConditionFactor create(StreamTokenizer tokenizer) throws WebDAVException {
        StateToken stateToken = new StateToken();
        try {
            int token = tokenizer.ttype;
            if (token != 60) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(token), "<"));
            }
            token = tokenizer.nextToken();
            if (token != -3) {
                throw new WebDAVException(400, Policy.bind("error.parseMissingURI", String.valueOf(token)));
            }
            stateToken.setURI(tokenizer.sval);
            token = tokenizer.nextToken();
            if (token != 62) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(token), ">"));
            }
            token = tokenizer.nextToken();
        }
        catch (IOException iOException) {}
        return stateToken;
    }

    public boolean equals(Object factor) {
        return factor != null && factor instanceof StateToken && this.getURI().equals(((StateToken)factor).getURI());
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String value) {
        this.uri = value;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.not()) {
            buffer.append("Not ");
        }
        buffer.append('<');
        buffer.append(this.getURI());
        buffer.append('>');
        return buffer.toString();
    }
}

