/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.audit;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.audit.event.ActivationLogEvent;
import org.drools.core.audit.event.ILogEventFilter;
import org.drools.core.audit.event.LogEvent;
import org.drools.core.audit.event.ObjectLogEvent;
import org.drools.core.audit.event.RuleBaseLogEvent;
import org.drools.core.audit.event.RuleFlowGroupLogEvent;
import org.drools.core.audit.event.RuleFlowLogEvent;
import org.drools.core.audit.event.RuleFlowNodeLogEvent;
import org.drools.core.audit.event.RuleFlowVariableLogEvent;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.event.ActivationCancelledEvent;
import org.drools.core.event.ActivationCreatedEvent;
import org.drools.core.event.AfterActivationFiredEvent;
import org.drools.core.event.AfterFunctionRemovedEvent;
import org.drools.core.event.AfterPackageAddedEvent;
import org.drools.core.event.AfterPackageRemovedEvent;
import org.drools.core.event.AfterProcessAddedEvent;
import org.drools.core.event.AfterProcessRemovedEvent;
import org.drools.core.event.AfterRuleAddedEvent;
import org.drools.core.event.AfterRuleBaseLockedEvent;
import org.drools.core.event.AfterRuleBaseUnlockedEvent;
import org.drools.core.event.AfterRuleRemovedEvent;
import org.drools.core.event.AgendaEventListener;
import org.drools.core.event.AgendaGroupPoppedEvent;
import org.drools.core.event.AgendaGroupPushedEvent;
import org.drools.core.event.BeforeActivationFiredEvent;
import org.drools.core.event.BeforeFunctionRemovedEvent;
import org.drools.core.event.BeforePackageAddedEvent;
import org.drools.core.event.BeforePackageRemovedEvent;
import org.drools.core.event.BeforeProcessAddedEvent;
import org.drools.core.event.BeforeProcessRemovedEvent;
import org.drools.core.event.BeforeRuleAddedEvent;
import org.drools.core.event.BeforeRuleBaseLockedEvent;
import org.drools.core.event.BeforeRuleBaseUnlockedEvent;
import org.drools.core.event.BeforeRuleRemovedEvent;
import org.drools.core.event.ObjectInsertedEvent;
import org.drools.core.event.ObjectRetractedEvent;
import org.drools.core.event.ObjectUpdatedEvent;
import org.drools.core.event.RuleBaseEventListener;
import org.drools.core.event.RuleFlowGroupActivatedEvent;
import org.drools.core.event.RuleFlowGroupDeactivatedEvent;
import org.drools.core.event.WorkingMemoryEventListener;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ReteooWorkingMemoryInterface;
import org.drools.core.rule.Declaration;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.drools.core.spi.Activation;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.internal.event.KnowledgeRuntimeEventManager;

public abstract class WorkingMemoryLogger
implements WorkingMemoryEventListener,
AgendaEventListener,
ProcessEventListener,
RuleBaseEventListener {
    private List<ILogEventFilter> filters = new ArrayList<ILogEventFilter>();

    public WorkingMemoryLogger() {
    }

    public WorkingMemoryLogger(WorkingMemory workingMemory) {
        workingMemory.addEventListener(this);
        workingMemory.addEventListener(this);
        InternalProcessRuntime processRuntime = ((InternalWorkingMemory)workingMemory).getProcessRuntime();
        if (processRuntime != null) {
            processRuntime.addEventListener(this);
        }
        workingMemory.addEventListener(this);
    }

    public WorkingMemoryLogger(KnowledgeRuntimeEventManager session) {
        if (session instanceof StatefulKnowledgeSessionImpl) {
            ReteooWorkingMemoryInterface eventManager = ((StatefulKnowledgeSessionImpl)session).session;
            eventManager.addEventListener(this);
            eventManager.addEventListener(this);
            eventManager.addEventListener(this);
            InternalProcessRuntime processRuntime = ((StatefulKnowledgeSessionImpl)session).session.getProcessRuntime();
            if (processRuntime != null) {
                processRuntime.addEventListener(this);
            }
        } else if (session instanceof StatelessKnowledgeSessionImpl) {
            ((StatelessKnowledgeSessionImpl)session).workingMemoryEventSupport.addEventListener(this);
            ((StatelessKnowledgeSessionImpl)session).agendaEventSupport.addEventListener(this);
            ((StatelessKnowledgeSessionImpl)session).processEventSupport.addEventListener(this);
            ((StatelessKnowledgeSessionImpl)session).getRuleBase().addEventListener(this);
        } else if (session instanceof CommandBasedStatefulKnowledgeSession) {
            ReteooWorkingMemoryInterface eventManager = ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)((CommandBasedStatefulKnowledgeSession)session).getCommandService().getContext()).getKieSession()).session;
            eventManager.addEventListener(this);
            eventManager.addEventListener(this);
            InternalProcessRuntime processRuntime = eventManager.getProcessRuntime();
            eventManager.addEventListener(this);
            if (processRuntime != null) {
                processRuntime.addEventListener(this);
            }
        } else {
            throw new IllegalArgumentException("Not supported session in logger: " + session.getClass());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.filters = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.filters);
    }

    public abstract void logEventCreated(LogEvent var1);

    private void filterLogEvent(LogEvent logEvent) {
        for (ILogEventFilter filter : this.filters) {
            if (filter.acceptEvent(logEvent)) continue;
            return;
        }
        this.logEventCreated(logEvent);
    }

    public void addFilter(ILogEventFilter filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filters.add(filter);
    }

    public void removeFilter(ILogEventFilter filter) {
        this.filters.remove(filter);
    }

    public void clearFilters() {
        this.filters.clear();
    }

    @Override
    public void objectInserted(ObjectInsertedEvent event) {
        this.filterLogEvent(new ObjectLogEvent(1, ((InternalFactHandle)event.getFactHandle()).getId(), event.getObject().toString()));
    }

    @Override
    public void objectUpdated(ObjectUpdatedEvent event) {
        this.filterLogEvent(new ObjectLogEvent(2, ((InternalFactHandle)event.getFactHandle()).getId(), event.getObject().toString()));
    }

    @Override
    public void objectRetracted(ObjectRetractedEvent event) {
        this.filterLogEvent(new ObjectLogEvent(3, ((InternalFactHandle)event.getFactHandle()).getId(), event.getOldObject().toString()));
    }

    @Override
    public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new ActivationLogEvent(4, WorkingMemoryLogger.getActivationId(event.getActivation()), event.getActivation().getRule().getName(), this.extractDeclarations(event.getActivation(), workingMemory), event.getActivation().getRule().getRuleFlowGroup()));
    }

    @Override
    public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new ActivationLogEvent(5, WorkingMemoryLogger.getActivationId(event.getActivation()), event.getActivation().getRule().getName(), this.extractDeclarations(event.getActivation(), workingMemory), event.getActivation().getRule().getRuleFlowGroup()));
    }

    @Override
    public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new ActivationLogEvent(6, WorkingMemoryLogger.getActivationId(event.getActivation()), event.getActivation().getRule().getName(), this.extractDeclarations(event.getActivation(), workingMemory), event.getActivation().getRule().getRuleFlowGroup()));
    }

    @Override
    public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new ActivationLogEvent(7, WorkingMemoryLogger.getActivationId(event.getActivation()), event.getActivation().getRule().getName(), this.extractDeclarations(event.getActivation(), workingMemory), event.getActivation().getRule().getRuleFlowGroup()));
    }

    private String extractDeclarations(Activation activation, WorkingMemory workingMemory) {
        StringBuilder result = new StringBuilder();
        LeftTuple tuple = activation.getTuple();
        Map<String, Declaration> declarations = activation.getSubRule().getOuterDeclarations();
        Iterator<Declaration> it = declarations.values().iterator();
        while (it.hasNext()) {
            Declaration declaration = it.next();
            InternalFactHandle handle = tuple.get(declaration);
            if (handle instanceof InternalFactHandle) {
                InternalFactHandle handleImpl = handle;
                if (handleImpl.getId() == -1) continue;
                Object value = declaration.getValue((InternalWorkingMemory)workingMemory, handleImpl.getObject());
                result.append(declaration.getIdentifier());
                result.append("=");
                if (value == null) {
                    result.append("null");
                } else {
                    result.append(value);
                    result.append("(");
                    result.append(handleImpl.getId());
                    result.append(")");
                }
            }
            if (!it.hasNext()) continue;
            result.append("; ");
        }
        return result.toString();
    }

    private static String getActivationId(Activation activation) {
        StringBuilder result = new StringBuilder(activation.getRule().getName());
        result.append(" [");
        LeftTuple tuple = activation.getTuple();
        InternalFactHandle[] handles = tuple.toFactHandles();
        for (int i = 0; i < handles.length; ++i) {
            result.append(handles[i].getId());
            if (i >= handles.length - 1) continue;
            result.append(", ");
        }
        return result.append("]").toString();
    }

    @Override
    public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
    }

    @Override
    public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
    }

    @Override
    public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new RuleFlowGroupLogEvent(12, event.getRuleFlowGroup().getName(), event.getRuleFlowGroup().size()));
    }

    @Override
    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new RuleFlowGroupLogEvent(13, event.getRuleFlowGroup().getName(), event.getRuleFlowGroup().size()));
    }

    @Override
    public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new RuleFlowGroupLogEvent(14, event.getRuleFlowGroup().getName(), event.getRuleFlowGroup().size()));
    }

    @Override
    public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event, WorkingMemory workingMemory) {
        this.filterLogEvent(new RuleFlowGroupLogEvent(15, event.getRuleFlowGroup().getName(), event.getRuleFlowGroup().size()));
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        this.filterLogEvent(new RuleFlowLogEvent(8, event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId()));
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
        this.filterLogEvent(new RuleFlowLogEvent(9, event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId()));
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
        this.filterLogEvent(new RuleFlowLogEvent(10, event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId()));
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        this.filterLogEvent(new RuleFlowLogEvent(11, event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId()));
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        this.filterLogEvent(new RuleFlowNodeLogEvent(24, this.createNodeId(event.getNodeInstance()), event.getNodeInstance().getNodeName(), this.createNodeInstanceId(event.getNodeInstance()), event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId()));
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
        this.filterLogEvent(new RuleFlowNodeLogEvent(25, this.createNodeId(event.getNodeInstance()), event.getNodeInstance().getNodeName(), this.createNodeInstanceId(event.getNodeInstance()), event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId()));
    }

    private String createNodeId(NodeInstance nodeInstance) {
        Node node = nodeInstance.getNode();
        if (node == null) {
            return "";
        }
        String nodeId = "" + node.getId();
        NodeContainer nodeContainer = node.getNodeContainer();
        while (nodeContainer != null && nodeContainer instanceof Node) {
            node = (Node)nodeContainer;
            if ((nodeContainer = node.getNodeContainer()).getClass().getName().endsWith("ForEachNode")) continue;
            nodeId = node.getId() + ":" + nodeId;
        }
        return nodeId;
    }

    private String createNodeInstanceId(NodeInstance nodeInstance) {
        String nodeInstanceId = "" + nodeInstance.getId();
        NodeInstanceContainer nodeContainer = nodeInstance.getNodeInstanceContainer();
        while (nodeContainer != null && nodeContainer instanceof NodeInstance) {
            nodeInstance = (NodeInstance)nodeContainer;
            nodeInstanceId = nodeInstance.getId() + ":" + nodeInstanceId;
            nodeContainer = nodeInstance.getNodeInstanceContainer();
        }
        return nodeInstanceId;
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        this.filterLogEvent(new RuleFlowNodeLogEvent(26, this.createNodeId(event.getNodeInstance()), event.getNodeInstance().getNodeName(), this.createNodeInstanceId(event.getNodeInstance()), event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId()));
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
        this.filterLogEvent(new RuleFlowNodeLogEvent(27, this.createNodeId(event.getNodeInstance()), event.getNodeInstance().getNodeName(), this.createNodeInstanceId(event.getNodeInstance()), event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId()));
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        this.filterLogEvent(new RuleFlowVariableLogEvent(32, event.getVariableId(), event.getVariableInstanceId(), event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId(), event.getNewValue() == null ? "null" : event.getNewValue().toString()));
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        this.filterLogEvent(new RuleFlowVariableLogEvent(33, event.getVariableId(), event.getVariableInstanceId(), event.getProcessInstance().getProcessId(), event.getProcessInstance().getProcessName(), event.getProcessInstance().getId(), event.getNewValue() == null ? "null" : event.getNewValue().toString()));
    }

    @Override
    public void afterPackageAdded(AfterPackageAddedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(17, event.getPackage().getName(), null));
    }

    @Override
    public void afterPackageRemoved(AfterPackageRemovedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(19, event.getPackage().getName(), null));
    }

    @Override
    public void afterRuleAdded(AfterRuleAddedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(21, event.getPackage().getName(), event.getRule().getName()));
    }

    @Override
    public void afterRuleRemoved(AfterRuleRemovedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(23, event.getPackage().getName(), event.getRule().getName()));
    }

    @Override
    public void beforePackageAdded(BeforePackageAddedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(16, event.getPackage().getName(), null));
    }

    @Override
    public void beforePackageRemoved(BeforePackageRemovedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(18, event.getPackage().getName(), null));
    }

    @Override
    public void beforeRuleAdded(BeforeRuleAddedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(20, event.getPackage().getName(), event.getRule().getName()));
    }

    @Override
    public void beforeRuleRemoved(BeforeRuleRemovedEvent event) {
        this.filterLogEvent(new RuleBaseLogEvent(22, event.getPackage().getName(), event.getRule().getName()));
    }

    @Override
    public void afterFunctionRemoved(AfterFunctionRemovedEvent event) {
    }

    @Override
    public void afterRuleBaseLocked(AfterRuleBaseLockedEvent event) {
    }

    @Override
    public void afterRuleBaseUnlocked(AfterRuleBaseUnlockedEvent event) {
    }

    @Override
    public void beforeFunctionRemoved(BeforeFunctionRemovedEvent event) {
    }

    @Override
    public void beforeRuleBaseLocked(BeforeRuleBaseLockedEvent event) {
    }

    @Override
    public void beforeRuleBaseUnlocked(BeforeRuleBaseUnlockedEvent event) {
    }

    @Override
    public void beforeProcessAdded(BeforeProcessAddedEvent event) {
    }

    @Override
    public void afterProcessAdded(AfterProcessAddedEvent event) {
    }

    @Override
    public void beforeProcessRemoved(BeforeProcessRemovedEvent event) {
    }

    @Override
    public void afterProcessRemoved(AfterProcessRemovedEvent event) {
    }
}

