/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.Package;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.Tuple;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

public class MVELAccumulator
implements MVELCompileable,
Accumulator,
Externalizable {
    private static final long serialVersionUID = 510L;
    MVELCompilationUnit initUnit;
    MVELCompilationUnit actionUnit;
    MVELCompilationUnit reverseUnit;
    MVELCompilationUnit resultUnit;
    private Serializable init;
    private Serializable action;
    private Serializable reverse;
    private Serializable result;

    public MVELAccumulator() {
    }

    public MVELAccumulator(MVELCompilationUnit initUnit, MVELCompilationUnit actionUnit, MVELCompilationUnit reverseUnit, MVELCompilationUnit resultUnit) {
        this.initUnit = initUnit;
        this.actionUnit = actionUnit;
        this.reverseUnit = reverseUnit;
        this.resultUnit = resultUnit;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.initUnit = (MVELCompilationUnit)in.readObject();
        this.actionUnit = (MVELCompilationUnit)in.readObject();
        this.reverseUnit = (MVELCompilationUnit)in.readObject();
        this.resultUnit = (MVELCompilationUnit)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.initUnit);
        out.writeObject(this.actionUnit);
        out.writeObject(this.reverseUnit);
        out.writeObject(this.resultUnit);
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        this.init = this.initUnit.getCompiledExpression(runtimeData);
        this.action = this.actionUnit.getCompiledExpression(runtimeData);
        this.result = this.resultUnit.getCompiledExpression(runtimeData);
        if (this.reverseUnit != null) {
            this.reverse = this.reverseUnit.getCompiledExpression(runtimeData);
        }
    }

    @Override
    public Serializable createContext() {
        HashMap<Integer, Object[]> shadow = null;
        if (this.reverse != null) {
            shadow = new HashMap<Integer, Object[]>();
        }
        return new MVELAccumulatorContext(shadow);
    }

    @Override
    public void init(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        Object[] localVars = new Object[this.initUnit.getOtherIdentifiers().length];
        MVELAccumulatorFactoryContext factoryContext = (MVELAccumulatorFactoryContext)workingMemoryContext;
        VariableResolverFactory factory = factoryContext.getInitFactory();
        this.initUnit.updateFactory(null, null, null, (LeftTuple)leftTuple, localVars, (InternalWorkingMemory)workingMemory, workingMemory.getGlobalResolver(), factory);
        Package pkg = workingMemory.getRuleBase().getPackage("MAIN");
        if (pkg != null) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("mvel");
            factory.setNextFactory((VariableResolverFactory)data.getFunctionFactory());
        }
        MVEL.executeExpression((Object)this.init, null, (VariableResolverFactory)factory);
        MVELCompilationUnit.DroolsVarFactory df = (MVELCompilationUnit.DroolsVarFactory)factory.getNextFactory();
        if (localVars.length > 0) {
            for (int i = 0; i < df.getOtherVarsLength(); ++i) {
                localVars[i] = factory.getIndexedVariableResolver(df.getOtherVarsPos() + i).getValue();
            }
        }
        ((MVELAccumulatorContext)context).setVariables(localVars);
    }

    @Override
    public void accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        Object[] localVars = ((MVELAccumulatorContext)context).getVariables();
        MVELAccumulatorFactoryContext factoryContext = (MVELAccumulatorFactoryContext)workingMemoryContext;
        VariableResolverFactory factory = factoryContext.getActionFactory();
        this.actionUnit.updateFactory(null, null, handle.getObject(), (LeftTuple)leftTuple, localVars, (InternalWorkingMemory)workingMemory, workingMemory.getGlobalResolver(), factory);
        MVELCompilationUnit.DroolsVarFactory df = (MVELCompilationUnit.DroolsVarFactory)factory.getNextFactory();
        if (this.reverse != null) {
            Object[] shadow = new Object[df.getOtherVarsPos()];
            for (int i = 0; i < df.getOtherVarsPos(); ++i) {
                shadow[i] = factory.getIndexedVariableResolver(i).getValue();
            }
            ((MVELAccumulatorContext)context).getShadow().put(handle.getId(), shadow);
        }
        MVEL.executeExpression((Object)this.action, null, (VariableResolverFactory)factory);
        if (localVars.length > 0) {
            for (int i = 0; i < df.getOtherVarsLength(); ++i) {
                localVars[i] = factory.getIndexedVariableResolver(df.getOtherVarsPos() + i).getValue();
            }
        }
        ((MVELAccumulatorContext)context).setVariables(localVars);
    }

    @Override
    public void reverse(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) throws Exception {
        int i;
        Object[] localVars = ((MVELAccumulatorContext)context).getVariables();
        MVELAccumulatorFactoryContext factoryContext = (MVELAccumulatorFactoryContext)workingMemoryContext;
        VariableResolverFactory factory = factoryContext.getActionFactory();
        MVELCompilationUnit.DroolsVarFactory df = (MVELCompilationUnit.DroolsVarFactory)factory.getNextFactory();
        Object[] vars = ((MVELAccumulatorContext)context).getShadow().remove(handle.getId());
        for (i = 0; i < df.getOtherVarsPos(); ++i) {
            factory.getIndexedVariableResolver(i).setValue(vars[i]);
        }
        if (localVars.length > 0) {
            for (i = 0; i < df.getOtherVarsLength(); ++i) {
                factory.getIndexedVariableResolver(df.getOtherVarsPos() + i).setValue(localVars[i]);
            }
        }
        MVEL.executeExpression((Object)this.reverse, null, (VariableResolverFactory)factory);
        if (localVars.length > 0) {
            for (i = 0; i < df.getOtherVarsLength(); ++i) {
                localVars[i] = factory.getIndexedVariableResolver(df.getOtherVarsPos() + i).getValue();
            }
        }
        ((MVELAccumulatorContext)context).setVariables(localVars);
    }

    @Override
    public Object getResult(Object workingMemoryContext, Object context, Tuple leftTuple, Declaration[] declarations, WorkingMemory workingMemory) throws Exception {
        Object[] localVars = ((MVELAccumulatorContext)context).getVariables();
        MVELAccumulatorFactoryContext factoryContext = (MVELAccumulatorFactoryContext)workingMemoryContext;
        VariableResolverFactory factory = factoryContext.getResultFactory();
        this.resultUnit.updateFactory(null, null, null, (LeftTuple)leftTuple, localVars, (InternalWorkingMemory)workingMemory, workingMemory.getGlobalResolver(), factory);
        Object result = MVEL.executeExpression((Object)this.result, null, (VariableResolverFactory)factory);
        return result;
    }

    @Override
    public boolean supportsReverse() {
        return this.reverse != null;
    }

    @Override
    public Object createWorkingMemoryContext() {
        return new MVELAccumulatorFactoryContext(this.initUnit.createFactory(), this.actionUnit.createFactory(), this.resultUnit.createFactory());
    }

    private static class MVELAccumulatorContext
    implements Serializable {
        private static final long serialVersionUID = 510L;
        private Object[] variables;
        private Map<Integer, Object[]> shadow;

        public MVELAccumulatorContext(Map<Integer, Object[]> shadow) {
            this.shadow = shadow;
        }

        public Object[] getVariables() {
            return this.variables;
        }

        public void setVariables(Object[] variables) {
            this.variables = variables;
        }

        public Map<Integer, Object[]> getShadow() {
            return this.shadow;
        }

        public void setShadow(Map<Integer, Object[]> shadow) {
            this.shadow = shadow;
        }
    }

    private static class MVELAccumulatorFactoryContext {
        VariableResolverFactory initFactory;
        VariableResolverFactory actionFactory;
        VariableResolverFactory resultFactory;

        public MVELAccumulatorFactoryContext(VariableResolverFactory initFactory, VariableResolverFactory actionFactory, VariableResolverFactory resultFactory) {
            this.initFactory = initFactory;
            this.actionFactory = actionFactory;
            this.resultFactory = resultFactory;
        }

        public VariableResolverFactory getInitFactory() {
            return this.initFactory;
        }

        public VariableResolverFactory getActionFactory() {
            return this.actionFactory;
        }

        public VariableResolverFactory getResultFactory() {
            return this.resultFactory;
        }
    }
}

