/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.rule.JavaDialectRuntimeData;

public class ProjectClassLoader
extends ClassLoader {
    private Map<String, byte[]> store;

    private ProjectClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static ProjectClassLoader createProjectClassLoader() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        if (parent == null) {
            parent = ProjectClassLoader.class.getClassLoader();
        }
        return new ProjectClassLoader(parent);
    }

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent) {
        if (parent == null) {
            return ProjectClassLoader.createProjectClassLoader();
        }
        return parent instanceof ProjectClassLoader ? (ProjectClassLoader)parent : new ProjectClassLoader(parent);
    }

    public static ProjectClassLoader createProjectClassLoader(ClassLoader parent, Map<String, byte[]> store) {
        ProjectClassLoader projectClassLoader = ProjectClassLoader.createProjectClassLoader(parent);
        projectClassLoader.store = store;
        return projectClassLoader;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e1) {
            try {
                return Class.forName(name, resolve, this.getParent());
            }
            catch (ClassNotFoundException e2) {
                byte[] bytecode = this.getBytecode(JavaDialectRuntimeData.convertClassToResourcePath(name));
                if (bytecode == null) {
                    throw e2;
                }
                return this.defineClass(name, bytecode, 0, bytecode.length);
            }
        }
    }

    public Class<?> defineClass(String name, byte[] bytecode) {
        return this.defineClass(name, JavaDialectRuntimeData.convertClassToResourcePath(name), bytecode);
    }

    public Class<?> defineClass(String name, String resourceName, byte[] bytecode) {
        this.storeClass(name, resourceName, bytecode);
        return this.defineClass(name, bytecode, 0, bytecode.length);
    }

    public void storeClass(String name, String resourceName, byte[] bytecode) {
        String pkgName;
        int lastDot = name.lastIndexOf(46);
        if (lastDot > 0 && this.getPackage(pkgName = name.substring(0, lastDot)) == null) {
            this.definePackage(pkgName, "", "", "", "", "", "", null);
        }
        if (this.store == null) {
            this.store = new HashMap<String, byte[]>();
        }
        this.store.put(resourceName, bytecode);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] bytecode = this.getBytecode(name);
        return bytecode != null ? new ByteArrayInputStream(bytecode) : super.getResourceAsStream(name);
    }

    public byte[] getBytecode(String resourceName) {
        return this.store == null ? null : this.store.get(resourceName);
    }

    public Map<String, byte[]> getStore() {
        return this.store;
    }
}

