/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.drools.core.factmodel.traits.LogicalTypeInconsistencyException;
import org.drools.core.factmodel.traits.NullTraitType;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitProxy;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.TypeHierarchy;

public class TraitTypeMap<T extends String, K extends Thing<C>, C>
extends TypeHierarchy<Thing<C>>
implements Map<String, Thing<C>>,
Externalizable {
    private Map<String, Thing<C>> innerMap;
    private BitSet currentTypeCode = new BitSet();

    public TraitTypeMap() {
    }

    public TraitTypeMap(Map map) {
        this.innerMap = map;
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.innerMap.containsValue(value);
    }

    @Override
    public Thing<C> get(Object key) {
        return this.innerMap.get(key);
    }

    @Override
    public Thing<C> put(String key, Thing<C> value) {
        BitSet code = ((TraitType)((Object)value)).getTypeCode();
        this.addMember(value, code);
        this.innerMap.put(key, value);
        this.currentTypeCode.or(code);
        return value;
    }

    @Override
    public void setBottomCode(BitSet code) {
        if (!this.hasKey(code)) {
            super.setBottomCode(code);
            this.addMember(new NullTraitType(code), code);
        }
    }

    public Thing<C> putSafe(String key, Thing<C> value) throws LogicalTypeInconsistencyException {
        BitSet code = ((TraitType)((Object)value)).getTypeCode();
        this.addMember(value, code);
        this.currentTypeCode.or(code);
        this.innerMap.put(key, value);
        return value;
    }

    @Override
    public Thing<C> remove(Object key) {
        this.removeMember(this.innerMap.get(key));
        Thing<C> t = this.innerMap.remove(key);
        this.resetCurrentCode();
        return t;
    }

    public Collection<Thing<C>> removeCascade(String traitName) {
        if (!this.innerMap.containsKey(traitName)) {
            return Collections.emptyList();
        }
        Thing<C> thing = this.innerMap.get(traitName);
        return this.removeCascade(((TraitType)((Object)thing)).getTypeCode());
    }

    public Collection<Thing<C>> removeCascade(BitSet code) {
        Collection<Thing<C>> subs = this.lowerDescendants(code);
        for (Thing thing : subs) {
            TraitType tt = (TraitType)((Object)thing);
            if (tt.isVirtual()) continue;
            this.removeMember(tt.getTypeCode());
            this.innerMap.remove(tt.getTraitName());
        }
        this.resetCurrentCode();
        return subs;
    }

    private void resetCurrentCode() {
        this.currentTypeCode = new BitSet();
        for (Thing<C> x : this.values()) {
            this.currentTypeCode.or(((TraitType)((Object)x)).getTypeCode());
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends Thing<C>> m) {
        for (String string : m.keySet()) {
            Thing<C> proxy = m.get(string);
            this.addMember(proxy, ((TraitProxy)((Object)proxy)).getTypeCode());
        }
        this.innerMap.putAll(m);
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.innerMap.keySet();
    }

    @Override
    public Collection<Thing<C>> values() {
        return this.innerMap.values();
    }

    @Override
    public Set<Map.Entry<String, Thing<C>>> entrySet() {
        return this.innerMap.entrySet();
    }

    @Override
    public String toString() {
        return "VetoableTypedMap{innerMap=" + this.innerMap + '}';
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.innerMap);
        objectOutput.writeObject(this.currentTypeCode);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.innerMap = (Map)objectInput.readObject();
        this.currentTypeCode = (BitSet)objectInput.readObject();
    }

    public Collection<Thing<C>> getMostSpecificTraits() {
        if (this.hasKey(this.getBottomCode())) {
            Thing b = (Thing)this.getMember(this.getBottomCode());
            if (((TraitType)((Object)b)).isVirtual()) {
                return this.parents(this.getBottomCode());
            }
            return Collections.singleton(b);
        }
        return this.parents(this.getBottomCode());
    }

    public BitSet getCurrentTypeCode() {
        return this.currentTypeCode;
    }
}

