/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Activation;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.BaseTimer;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.IntervalTrigger;
import org.drools.core.time.impl.Timer;
import org.kie.api.runtime.Calendars;

public class IntervalTimer
extends BaseTimer
implements Timer,
Externalizable {
    private Date startTime;
    private Date endTime;
    private int repeatLimit;
    private long delay;
    private long period;

    public IntervalTimer() {
    }

    public IntervalTimer(Date startTime, Date endTime, int repeatLimit, long delay, long period) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.repeatLimit = repeatLimit;
        this.delay = delay;
        this.period = period;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.startTime);
        out.writeObject(this.endTime);
        out.writeInt(this.repeatLimit);
        out.writeLong(this.delay);
        out.writeLong(this.period);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startTime = (Date)in.readObject();
        this.endTime = (Date)in.readObject();
        this.repeatLimit = in.readInt();
        this.delay = in.readLong();
        this.period = in.readLong();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getPeriod() {
        return this.period;
    }

    @Override
    public Trigger createTrigger(Activation item, InternalWorkingMemory wm) {
        long timestamp = wm.getTimerService().getCurrentTime();
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = wm.getCalendars();
        return this.createTrigger(timestamp, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, LeftTuple leftTuple, DefaultJobHandle jh, String[] calendarNames, Calendars calendars, Declaration[][] declrs, InternalWorkingMemory wm) {
        long newDelay;
        IntervalTrigger preTrig;
        long timeSinceLastFire = 0L;
        if (jh != null && (preTrig = (IntervalTrigger)jh.getTimerJobInstance().getTrigger()).hasNextFireTime() != null) {
            timeSinceLastFire = timestamp - preTrig.getLastFireTime().getTime();
        }
        if ((newDelay = this.delay - timeSinceLastFire) < 0L) {
            newDelay = 0L;
        }
        return new IntervalTrigger(timestamp, this.startTime, this.endTime, this.repeatLimit, newDelay, this.period, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        return new IntervalTrigger(timestamp, this.startTime, this.endTime, this.repeatLimit, this.delay, this.period, calendarNames, calendars);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.delay ^ this.delay >>> 32);
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (int)(this.period ^ this.period >>> 32);
        result = 31 * result + this.repeatLimit;
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalTimer other = (IntervalTimer)obj;
        if (this.delay != other.delay) {
            return false;
        }
        if (this.repeatLimit != other.repeatLimit) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }

    @Override
    public ConditionalElement clone() {
        return new IntervalTimer(this.startTime, this.endTime, this.repeatLimit, this.delay, this.period);
    }
}

