/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.command;

import java.util.List;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.command.AbstractHistoryLogCommand;
import org.kie.internal.command.Context;

public class FindNodeInstancesCommand
extends AbstractHistoryLogCommand<List<NodeInstanceLog>> {
    private static final long serialVersionUID = 5374910016873481604L;
    private final long processInstanceId;
    private final String nodeId;

    public FindNodeInstancesCommand(long processInstanceId) {
        this.processInstanceId = processInstanceId;
        this.nodeId = null;
    }

    public FindNodeInstancesCommand(long processInstanceId, String nodeId) {
        this.processInstanceId = processInstanceId;
        this.nodeId = nodeId;
        if (nodeId == null || nodeId.isEmpty()) {
            throw new IllegalArgumentException("The nodeId field must not be null or empty.");
        }
    }

    public List<NodeInstanceLog> execute(Context cntxt) {
        this.setLogEnvironment(cntxt);
        if (this.nodeId == null || this.nodeId.isEmpty()) {
            return this.auditLogService.findNodeInstances(this.processInstanceId);
        }
        return this.auditLogService.findNodeInstances(this.processInstanceId, this.nodeId);
    }

    public String toString() {
        if (this.nodeId == null || this.nodeId.isEmpty()) {
            return JPAAuditLogService.class.getSimpleName() + ".findNodeInstances(" + this.processInstanceId + ")";
        }
        return "JPAProcessInstanceDbLog.findNodeInstances(" + this.processInstanceId + ", " + this.nodeId + ")";
    }
}

