/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.process.audit.jms.AsyncAuditLogProducer;
import org.kie.api.runtime.KieSession;

public class AuditLoggerFactory {
    public static AbstractAuditLogger newInstance(Type type, KieSession ksession, Map<String, Object> properties) {
        AbstractAuditLogger logger = null;
        switch (type) {
            case JPA: {
                logger = new JPAWorkingMemoryDbLogger(ksession);
                break;
            }
            case JMS: {
                Queue queue;
                ConnectionFactory connFactory;
                boolean transacted = true;
                if (properties.containsKey("jbpm.audit.jms.transacted")) {
                    transacted = (Boolean)properties.get("jbpm.audit.jms.transacted");
                }
                logger = new AsyncAuditLogProducer(ksession, transacted);
                if (properties.containsKey("jbpm.audit.jms.connection.factory")) {
                    connFactory = (ConnectionFactory)properties.get("jbpm.audit.jms.connection.factory");
                    ((AsyncAuditLogProducer)logger).setConnectionFactory(connFactory);
                }
                if (properties.containsKey("jbpm.audit.jms.queue")) {
                    queue = (Queue)properties.get("jbpm.audit.jms.queue");
                    ((AsyncAuditLogProducer)logger).setQueue(queue);
                }
                try {
                    if (properties.containsKey("jbpm.audit.jms.connection.factory.jndi")) {
                        connFactory = (ConnectionFactory)InitialContext.doLookup((String)properties.get(properties.get("jbpm.audit.jms.connection.factory.jndi")));
                        ((AsyncAuditLogProducer)logger).setConnectionFactory(connFactory);
                    }
                    if (!properties.containsKey("jbpm.audit.jms.queue.jndi")) break;
                    queue = (Queue)InitialContext.doLookup((String)properties.get("jbpm.audit.jms.queue.jndi"));
                    ((AsyncAuditLogProducer)logger).setQueue(queue);
                    break;
                }
                catch (NamingException e) {
                    throw new RuntimeException("Error when looking up ConnectionFactory/Queue", e);
                }
            }
        }
        return logger;
    }

    public static AbstractAuditLogger newJPAInstance(EntityManagerFactory emf) {
        return new JPAWorkingMemoryDbLogger(emf);
    }

    public static AbstractAuditLogger newJMSInstance(Map<String, Object> properties) {
        Queue queue;
        ConnectionFactory connFactory;
        AsyncAuditLogProducer logger = new AsyncAuditLogProducer();
        boolean transacted = true;
        if (properties.containsKey("jbpm.audit.jms.transacted")) {
            transacted = (Boolean)properties.get("jbpm.audit.jms.transacted");
        }
        logger.setTransacted(transacted);
        if (properties.containsKey("jbpm.audit.jms.connection.factory")) {
            connFactory = (ConnectionFactory)properties.get("jbpm.audit.jms.connection.factory");
            logger.setConnectionFactory(connFactory);
        }
        if (properties.containsKey("jbpm.audit.jms.queue")) {
            queue = (Queue)properties.get("jbpm.audit.jms.queue");
            logger.setQueue(queue);
        }
        try {
            if (properties.containsKey("jbpm.audit.jms.connection.factory.jndi")) {
                connFactory = (ConnectionFactory)InitialContext.doLookup((String)properties.get(properties.get("jbpm.audit.jms.connection.factory.jndi")));
                logger.setConnectionFactory(connFactory);
            }
            if (properties.containsKey("jbpm.audit.jms.queue.jndi")) {
                queue = (Queue)InitialContext.doLookup((String)properties.get("jbpm.audit.jms.queue.jndi"));
                logger.setQueue(queue);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Error when looking up ConnectionFactory/Queue", e);
        }
        return logger;
    }

    public static AbstractAuditLogger newJMSInstance(boolean transacted, ConnectionFactory connFactory, Queue queue) {
        AsyncAuditLogProducer logger = new AsyncAuditLogProducer();
        logger.setTransacted(transacted);
        logger.setConnectionFactory(connFactory);
        logger.setQueue(queue);
        return logger;
    }

    public static enum Type {
        JPA,
        JMS;

    }
}

