/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.lang.dsl.DSLMapping;
import org.drools.compiler.lang.dsl.DSLMappingEntry;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.builder.Util;
import org.drools.eclipse.editors.completion.DSLTree;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class DSLAdapter {
    private String dslConfigName;
    private boolean valid = false;
    private List conditionProposals = new ArrayList();
    private List consequenceProposals = new ArrayList();
    private DSLTree dslTree = new DSLTree();
    private static final Pattern EXPANDER_PATTERN = Pattern.compile("\\n\\s*expander\\s*(.*)\\.dsl", 40);

    public DSLAdapter(String content, IFile input) throws CoreException {
        this.dslConfigName = DSLAdapter.findDSLConfigName(content, (IResource)input);
        if (this.dslConfigName == null) {
            return;
        }
        this.loadConfig(input);
    }

    public static Reader getDSLContent(String ruleSource, IResource input) throws CoreException {
        IFile dslConf;
        String dslFileName = DSLAdapter.findDSLConfigName(ruleSource, input);
        if (dslFileName == null) {
            return null;
        }
        IResource res = DSLAdapter.findDSLResource(input, dslFileName);
        if (res instanceof IFile && (dslConf = (IFile)res).exists()) {
            return new InputStreamReader(dslConf.getContents());
        }
        return null;
    }

    private void loadConfig(IFile input) {
        IFile dslConf;
        IResource res = DSLAdapter.findDSLResource((IResource)input, this.dslConfigName);
        if (res instanceof IFile && (dslConf = (IFile)res).exists()) {
            InputStream stream = null;
            try {
                try {
                    stream = dslConf.getContents();
                    this.readConfig(stream);
                    this.valid = true;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to open DSL config file. (Exception: " + e.getMessage() + ")");
                }
            }
            finally {
                this.closeStream(stream);
            }
        }
    }

    private static IResource findDSLResource(IResource input, String dslFileName) {
        IResource res = input.getParent().findMember(dslFileName);
        if (res == null) {
            res = input.getParent().getParent().findMember(dslFileName);
        }
        if (res == null) {
            res = input.getProject().findMember(dslFileName);
        }
        return res;
    }

    void readConfig(InputStream stream) throws IOException, CoreException {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        file.parseAndLoad((Reader)new InputStreamReader(stream));
        DSLMapping grammar = file.getMapping();
        List conditions = grammar.getEntries(DSLMappingEntry.CONDITION);
        List consequences = grammar.getEntries(DSLMappingEntry.CONSEQUENCE);
        this.conditionProposals = this.buildProposals(conditions);
        this.consequenceProposals = this.buildProposals(consequences);
        this.dslTree.buildTree(grammar);
    }

    private List buildProposals(List suggestions) {
        ArrayList<String> result = new ArrayList<String>(suggestions.size());
        for (DSLMappingEntry text : suggestions) {
            result.add(text.getMappingKey());
        }
        return result;
    }

    private void closeStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    DSLAdapter() {
    }

    private static String findDSLConfigName(String content, IResource input) throws CoreException {
        String dslConfigName = DSLAdapter.findDSLConfigName(content);
        if (dslConfigName == null && input != null && input.getParent() != null) {
            MyResourceVisitor visitor = new MyResourceVisitor();
            input.getParent().accept((IResourceVisitor)visitor, 1, 0);
            IResource packageDef = visitor.getPackageDef();
            if (packageDef != null && packageDef instanceof IFile) {
                IFile file = (IFile)packageDef;
                try {
                    String pContent = new String(Util.getResourceContentsAsCharArray(file));
                    dslConfigName = DSLAdapter.findDSLConfigName(pContent);
                }
                catch (CoreException e) {
                    DroolsEclipsePlugin.log(e);
                }
            }
        }
        return dslConfigName;
    }

    static String findDSLConfigName(String content) {
        String name = null;
        Matcher matches = EXPANDER_PATTERN.matcher(content);
        if (matches.find()) {
            name = String.valueOf(matches.group(1)) + ".dsl";
        }
        return name;
    }

    String getDSLConfigName() {
        return this.dslConfigName;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean hasConditions() {
        return this.conditionProposals.size() > 0;
    }

    public boolean hasConsequences() {
        return this.consequenceProposals.size() > 0;
    }

    public List listConditionItems() {
        return this.conditionProposals;
    }

    public List listConsequenceItems() {
        return this.consequenceProposals;
    }

    public DSLTree getDSLTree() {
        return this.dslTree;
    }

    private static class MyResourceVisitor
    implements IResourceVisitor {
        private IResource packageDef;

        private MyResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if ("package".equals(resource.getFileExtension())) {
                this.packageDef = resource;
            }
            return true;
        }

        public IResource getPackageDef() {
            return this.packageDef;
        }
    }
}

