/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.RBTree;
import org.drools.core.util.index.IndexUtil;
import org.drools.core.util.index.RightTupleList;

public class RightTupleIndexRangeRBTree
implements RightTupleMemory,
Externalizable {
    private RBTree<Comparable<Comparable>, RightTupleList> tree;
    private AbstractHashTable.FieldIndex ascendingIndex;
    private IndexUtil.ConstraintType ascendingConstraintType;
    private AbstractHashTable.FieldIndex descendingIndex;
    private IndexUtil.ConstraintType descendingConstraintType;
    private RightTupleBoundedFastIterator rightTupleBoundedFastIterator;
    private int size;

    public RightTupleIndexRangeRBTree() {
    }

    public RightTupleIndexRangeRBTree(IndexUtil.ConstraintType ascendingConstraintType, AbstractHashTable.FieldIndex ascendingIndex, IndexUtil.ConstraintType descendingConstraintType, AbstractHashTable.FieldIndex descendingIndex) {
        this.ascendingIndex = ascendingIndex;
        this.ascendingConstraintType = ascendingConstraintType;
        this.descendingIndex = descendingIndex;
        this.descendingConstraintType = descendingConstraintType;
        this.tree = new RBTree();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tree);
        out.writeObject(this.ascendingIndex);
        out.writeObject((Object)this.ascendingConstraintType);
        out.writeObject(this.descendingIndex);
        out.writeObject((Object)this.descendingConstraintType);
        out.writeInt(this.size);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tree = (RBTree)in.readObject();
        this.ascendingIndex = (AbstractHashTable.FieldIndex)in.readObject();
        this.ascendingConstraintType = (IndexUtil.ConstraintType)((Object)in.readObject());
        this.descendingIndex = (AbstractHashTable.FieldIndex)in.readObject();
        this.descendingConstraintType = (IndexUtil.ConstraintType)((Object)in.readObject());
        this.size = in.readInt();
    }

    @Override
    public void add(RightTuple tuple) {
        Comparable key = this.getRightIndexedValue(tuple);
        RightTupleList list = this.tree.lookup(key);
        if (list == null) {
            list = new RightTupleList();
            this.tree.insert(key, list);
        }
        list.add(tuple);
        ++this.size;
    }

    @Override
    public void remove(RightTuple tuple) {
        tuple.getMemory().remove(tuple);
        --this.size;
    }

    @Override
    public void removeAdd(RightTuple tuple) {
        this.remove(tuple);
        this.add(tuple);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Entry[] toArray() {
        RBTree.Node node;
        FastIterator it = this.tree.fastIterator();
        if (it == null) {
            return new Entry[0];
        }
        ArrayList toBeRemoved = new ArrayList();
        ArrayList<RightTuple> result = new ArrayList<RightTuple>();
        while ((node = (RBTree.Node)it.next(null)) != null) {
            RightTupleList bucket = (RightTupleList)node.value;
            if (bucket.size() == 0) {
                toBeRemoved.add(node.key);
                continue;
            }
            for (RightTuple entry = bucket.getFirst(); entry != null; entry = (RightTuple)entry.getNext()) {
                result.add(entry);
            }
        }
        for (Comparable key : toBeRemoved) {
            this.tree.delete(key);
        }
        return result.toArray(new LeftTuple[result.size()]);
    }

    @Override
    public RightTuple getFirst(LeftTuple leftTuple, InternalFactHandle factHandle, FastIterator rightTupleIterator) {
        Comparable lowerBound;
        RightTuple rightTuple;
        if (rightTupleIterator instanceof RightTupleBoundedFastIterator) {
            ((RightTupleBoundedFastIterator)rightTupleIterator).setUpperBound(leftTuple);
        }
        return (rightTuple = this.getNext(lowerBound = this.getLeftAscendingIndexedValue(leftTuple), true)) == null ? null : this.checkUpperBound(rightTuple, this.getLeftDescendingIndexedValue(leftTuple));
    }

    private RightTuple checkUpperBound(RightTuple rightTuple, Comparable upperBound) {
        int compResult = this.getRightIndexedValue(rightTuple).compareTo(upperBound);
        return compResult < 0 || compResult == 0 && this.descendingConstraintType == IndexUtil.ConstraintType.LESS_OR_EQUAL ? rightTuple : null;
    }

    @Override
    public Iterator iterator() {
        RightTupleList list = (RightTupleList)this.tree.first().value;
        RightTuple firstTuple = list != null ? list.first : null;
        return new FastIterator.IteratorAdapter(this.fastIterator(), firstTuple);
    }

    @Override
    public boolean contains(RightTuple tuple) {
        Comparable key = this.getRightIndexedValue(tuple);
        return this.tree.lookup(key) != null;
    }

    @Override
    public FastIterator fastIterator() {
        if (this.rightTupleBoundedFastIterator != null) {
            this.rightTupleBoundedFastIterator = new RightTupleBoundedFastIterator();
        }
        return this.rightTupleBoundedFastIterator;
    }

    @Override
    public FastIterator fullFastIterator() {
        if (this.rightTupleBoundedFastIterator != null) {
            this.rightTupleBoundedFastIterator = new RightTupleBoundedFastIterator();
        }
        return this.rightTupleBoundedFastIterator;
    }

    @Override
    public FastIterator fullFastIterator(RightTuple tuple) {
        FastIterator fastIterator = this.fullFastIterator();
        Comparable key = this.getRightIndexedValue(tuple);
        fastIterator.next(this.getNext(key, true));
        return fastIterator;
    }

    @Override
    public RightTupleMemory.IndexType getIndexType() {
        return RightTupleMemory.IndexType.COMPARISON;
    }

    private RightTuple getNext(Comparable lowerBound, boolean first) {
        RBTree.Node<Comparable<Comparable>, RightTupleList> firstNode;
        while (true) {
            switch (this.ascendingConstraintType) {
                case GREATER_THAN: {
                    firstNode = this.tree.findNearestNode(lowerBound, false, RBTree.Boundary.LOWER);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    firstNode = this.tree.findNearestNode(lowerBound, first, RBTree.Boundary.LOWER);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot call remove constraint of type: " + (Object)((Object)this.ascendingConstraintType));
                }
            }
            if (firstNode == null || ((RightTupleList)firstNode.value).size() != 0) break;
            this.tree.delete((Comparable<Comparable>)firstNode.key);
        }
        return firstNode == null ? null : ((RightTupleList)firstNode.value).getFirst();
    }

    private Comparable getLeftAscendingIndexedValue(LeftTuple leftTuple) {
        return (Comparable)this.ascendingIndex.getDeclaration().getExtractor().getValue(leftTuple.get(this.ascendingIndex.getDeclaration()).getObject());
    }

    private Comparable getLeftDescendingIndexedValue(LeftTuple leftTuple) {
        return (Comparable)this.descendingIndex.getDeclaration().getExtractor().getValue(leftTuple.get(this.descendingIndex.getDeclaration()).getObject());
    }

    private Comparable getRightIndexedValue(RightTuple rightTuple) {
        return (Comparable)this.ascendingIndex.getExtractor().getValue(rightTuple.getFactHandle().getObject());
    }

    public class RightTupleBoundedFastIterator
    implements FastIterator {
        private Comparable upperBound;

        public void setUpperBound(LeftTuple leftTuple) {
            this.upperBound = RightTupleIndexRangeRBTree.this.getLeftDescendingIndexedValue(leftTuple);
        }

        @Override
        public Entry next(Entry object) {
            if (object == null) {
                return null;
            }
            RightTuple rightTuple = (RightTuple)object;
            RightTuple next = (RightTuple)rightTuple.getNext();
            if (next != null) {
                return next;
            }
            Comparable key = RightTupleIndexRangeRBTree.this.getRightIndexedValue(rightTuple);
            next = RightTupleIndexRangeRBTree.this.getNext(key, false);
            return next == null ? null : RightTupleIndexRangeRBTree.this.checkUpperBound(next, this.upperBound);
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }
    }
}

