/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.List;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.CompositeContextNodeHandler;
import org.jbpm.bpmn2.xml.ProcessHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.kie.api.definition.process.NodeContainer;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AdHocSubProcessHandler
extends CompositeContextNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        DynamicNode result = new DynamicNode();
        VariableScope variableScope = new VariableScope();
        result.addContext((Context)variableScope);
        result.setDefaultContext((Context)variableScope);
        return result;
    }

    @Override
    public Class generateNodeFor() {
        return DynamicNode.class;
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        DynamicNode dynamicNode = (DynamicNode)node;
        String cancelRemainingInstances = element.getAttribute("cancelRemainingInstances");
        if ("false".equals(cancelRemainingInstances)) {
            dynamicNode.setCancelRemainingInstances(false);
        }
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String expression;
            String nodeName = xmlNode.getNodeName();
            if (!"completionCondition".equals(nodeName) || !"getActivityInstanceAttribute(\"numberOfActiveInstances\") == 0".equals(expression = xmlNode.getTextContent())) continue;
            dynamicNode.setAutoComplete(true);
        }
        List connections = (List)dynamicNode.getMetaData("BPMN.Connections");
        ProcessHandler.linkConnections((NodeContainer)dynamicNode, connections);
        ProcessHandler.linkBoundaryEvents((NodeContainer)dynamicNode);
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        DynamicNode dynamicNode = (DynamicNode)node;
        this.writeNode("adHocSubProcess", (Node)dynamicNode, xmlDump, metaDataType);
        if (!dynamicNode.isCancelRemainingInstances()) {
            xmlDump.append(" cancelRemainingInstances=\"false\"");
        }
        xmlDump.append(" ordering=\"Parallel\" >" + EOL);
        List<Node> subNodes = this.getSubNodes((CompositeNode)dynamicNode);
        XmlBPMNProcessDumper.INSTANCE.visitNodes(subNodes, xmlDump, metaDataType);
        this.visitConnectionsAndAssociations((Node)dynamicNode, xmlDump, metaDataType);
        if (dynamicNode.isAutoComplete()) {
            xmlDump.append("    <completionCondition xsi:type=\"tFormalExpression\">getActivityInstanceAttribute(\"numberOfActiveInstances\") == 0</completionCondition>" + EOL);
        }
        this.endNode("adHocSubProcess", xmlDump);
    }
}

