/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Comparator;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.StackEntry;
import org.drools.core.phreak.TupleEntry;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.rule.Rule;
import org.drools.core.spi.Activation;
import org.drools.core.spi.AgendaFilter;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.LeftTupleList;
import org.kie.api.event.rule.MatchCancelledCause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleExecutor {
    protected static transient Logger log = LoggerFactory.getLogger(RuleExecutor.class);
    private static final RuleNetworkEvaluator NETWORK_EVALUATOR = new RuleNetworkEvaluator();
    private final PathMemory pmem;
    private RuleAgendaItem ruleAgendaItem;
    private LeftTupleList tupleList;
    private BinaryHeapQueue queue;
    private volatile boolean dirty;
    private boolean declarativeAgendaEnabled;
    private boolean fireExitedEarly;

    public RuleExecutor(PathMemory pmem, RuleAgendaItem ruleAgendaItem, boolean declarativeAgendaEnabled) {
        this.pmem = pmem;
        this.ruleAgendaItem = ruleAgendaItem;
        this.tupleList = new LeftTupleList();
        this.declarativeAgendaEnabled = declarativeAgendaEnabled;
        if (ruleAgendaItem.getRule().getSalience().isDynamic()) {
            this.queue = new BinaryHeapQueue(SalienceComparator.INSTANCE);
        }
    }

    public void evaluateNetwork(InternalWorkingMemory wm) {
        NETWORK_EVALUATOR.evaluateNetwork(this.pmem, null, this, wm);
        this.setDirty(false);
        wm.executeQueuedActions();
    }

    public int evaluateNetworkAndFire(InternalWorkingMemory wm, AgendaFilter filter, int fireCount, int fireLimit) {
        LinkedList<StackEntry> outerStack = new LinkedList<StackEntry>();
        InternalAgenda agenda = (InternalAgenda)wm.getAgenda();
        boolean fireUntilHalt = agenda.isFireUntilHalt();
        this.reEvaluateNetwork(wm, outerStack, fireUntilHalt);
        wm.executeQueuedActions();
        return this.fire(wm, filter, fireCount, fireLimit, outerStack, agenda, fireUntilHalt);
    }

    public void fire(InternalWorkingMemory wm, LinkedList<StackEntry> outerStack) {
        InternalAgenda agenda = (InternalAgenda)wm.getAgenda();
        boolean fireUntilHalt = agenda.isFireUntilHalt();
        this.fire(wm, null, 0, Integer.MAX_VALUE, outerStack, agenda, fireUntilHalt);
    }

    private int fire(InternalWorkingMemory wm, AgendaFilter filter, int fireCount, int fireLimit, LinkedList<StackEntry> outerStack, InternalAgenda agenda, boolean fireUntilHalt) {
        int localFireCount = 0;
        if (!this.tupleList.isEmpty()) {
            RuleAgendaItem nextRule;
            RuleTerminalNode rtn = (RuleTerminalNode)this.pmem.getNetworkNode();
            if (!this.fireExitedEarly && this.isDeclarativeAgendaEnabled() && !this.isHighestSalience(nextRule = agenda.peekNextRule(), this.ruleAgendaItem.getSalience())) {
                this.fireExitedEarly = true;
                return localFireCount;
            }
            while (!this.tupleList.isEmpty()) {
                RuleAgendaItem nextRule2;
                LeftTuple leftTuple;
                if (this.queue != null) {
                    leftTuple = (LeftTuple)((Object)this.queue.dequeue());
                    this.tupleList.remove(leftTuple);
                } else {
                    leftTuple = this.tupleList.removeFirst();
                    ((Activation)((Object)leftTuple)).setQueued(false);
                }
                rtn = (RuleTerminalNode)leftTuple.getSink();
                Rule rule = rtn.getRule();
                PropagationContext pctx = leftTuple.getPropagationContext();
                pctx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, pctx);
                if (this.cancelAndContinue(wm, rtn, rule, leftTuple, pctx, filter)) continue;
                AgendaItem item = (AgendaItem)((Object)leftTuple);
                if (agenda.getActivationsFilter() != null && !agenda.getActivationsFilter().accept(item, wm, rtn)) continue;
                agenda.fireActivation(item);
                ++localFireCount;
                if (rtn.getLeftTupleSource() == null) break;
                int salience = this.ruleAgendaItem.getSalience();
                if (this.queue != null && !this.queue.isEmpty() && salience != this.queue.peek().getSalience()) {
                    this.ruleAgendaItem.dequeue();
                    this.ruleAgendaItem.setSalience(this.queue.peek().getSalience());
                    this.ruleAgendaItem.getAgendaGroup().add(this.ruleAgendaItem);
                    salience = this.ruleAgendaItem.getSalience();
                }
                if (this.haltRuleFiring(nextRule2 = agenda.peekNextRule(), fireCount, fireLimit, localFireCount, agenda, salience)) break;
                this.reEvaluateNetwork(wm, outerStack, fireUntilHalt);
                wm.executeQueuedActions();
                if (!this.tupleList.isEmpty() || outerStack.isEmpty()) continue;
                StackEntry entry = outerStack.removeFirst();
                NETWORK_EVALUATOR.evalStackEntry(entry, outerStack, outerStack, this, wm);
            }
        }
        this.removeRuleAgendaItemWhenEmpty(wm);
        this.fireExitedEarly = false;
        return localFireCount;
    }

    public PathMemory getPathMemory() {
        return this.pmem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRuleAgendaItemWhenEmpty(InternalWorkingMemory wm) {
        if (!this.dirty && this.tupleList.isEmpty()) {
            RuleAgendaItem ruleAgendaItem = this.ruleAgendaItem;
            synchronized (ruleAgendaItem) {
                if (!this.dirty && this.tupleList.isEmpty()) {
                    if (log.isTraceEnabled()) {
                        log.trace("Removing RuleAgendaItem " + this.ruleAgendaItem);
                    }
                    this.ruleAgendaItem.remove();
                    if (this.ruleAgendaItem.getRule().isEager()) {
                        ((InternalAgenda)wm.getAgenda()).removeEagerRuleAgendaItem(this.ruleAgendaItem);
                    }
                }
            }
        }
    }

    public void reEvaluateNetwork(InternalWorkingMemory wm, LinkedList<StackEntry> outerStack, boolean fireUntilHalt) {
        if (this.isDirty() || this.pmem.getQueue() != null && !this.pmem.getQueue().isEmpty()) {
            this.setDirty(false);
            boolean evaled = false;
            if (this.pmem.getQueue() != null) {
                while (!this.pmem.getQueue().isEmpty()) {
                    this.removeQueuedTupleEntry();
                    NETWORK_EVALUATOR.evaluateNetwork(this.pmem, outerStack, this, wm);
                    evaled = true;
                }
            }
            if (!evaled) {
                NETWORK_EVALUATOR.evaluateNetwork(this.pmem, outerStack, this, wm);
            }
        }
    }

    private void removeQueuedTupleEntry() {
        TupleEntry tupleEntry = this.pmem.getQueue().remove();
        PropagationContext originalPctx = tupleEntry.getPropagationContext();
        boolean repeat = true;
        while (repeat) {
            PropagationContext pctx;
            if (log.isTraceEnabled()) {
                log.trace("Stream removed entry {} {} size {}", new Object[]{System.identityHashCode(this.pmem.getQueue()), tupleEntry, this.pmem.getQueue().size()});
            }
            if (tupleEntry.getLeftTuple() != null) {
                SegmentMemory sm = tupleEntry.getNodeMemory().getSegmentMemory();
                LeftTupleSets tuples = sm.getStagedLeftTuples();
                tupleEntry.getLeftTuple().setPropagationContext(tupleEntry.getPropagationContext());
                switch (tupleEntry.getPropagationContext().getType()) {
                    case 0: 
                    case 3: {
                        tuples.addInsert(tupleEntry.getLeftTuple());
                        break;
                    }
                    case 2: {
                        tuples.addUpdate(tupleEntry.getLeftTuple());
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        tuples.addDelete(tupleEntry.getLeftTuple());
                    }
                }
            } else {
                BetaMemory bm = (BetaMemory)tupleEntry.getNodeMemory();
                tupleEntry.getRightTuple().setPropagationContext(tupleEntry.getPropagationContext());
                switch (tupleEntry.getPropagationContext().getType()) {
                    case 0: 
                    case 3: {
                        bm.getStagedRightTuples().addInsert(tupleEntry.getRightTuple());
                        break;
                    }
                    case 2: {
                        bm.getStagedRightTuples().addUpdate(tupleEntry.getRightTuple());
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        bm.getStagedRightTuples().addDelete(tupleEntry.getRightTuple());
                    }
                }
            }
            repeat = !this.pmem.getQueue().isEmpty() ? (pctx = (tupleEntry = this.pmem.getQueue().peek()).getPropagationContext()).getPropagationNumber() == originalPctx.getPropagationNumber() : false;
            if (!repeat) continue;
            tupleEntry = this.pmem.getQueue().remove();
        }
    }

    public RuleAgendaItem getRuleAgendaItem() {
        return this.ruleAgendaItem;
    }

    private boolean cancelAndContinue(InternalWorkingMemory wm, RuleTerminalNode rtn, Rule rule, LeftTuple leftTuple, PropagationContext pctx, AgendaFilter filter) {
        if (!rule.isEffective(leftTuple, rtn, wm) || rule.isNoLoop() && rule.equals(pctx.getRuleOrigin())) {
            return true;
        }
        if (rule.getCalendars() != null) {
            long timestamp = wm.getSessionClock().getCurrentTime();
            for (String cal : rule.getCalendars()) {
                if (wm.getCalendars().get(cal).isTimeIncluded(timestamp)) continue;
                return true;
            }
        }
        return filter != null && !filter.accept((Activation)((Object)leftTuple));
    }

    private boolean haltRuleFiring(RuleAgendaItem nextRule, int fireCount, int fireLimit, int localFireCount, InternalAgenda agenda, int salience) {
        return !agenda.continueFiring(0) || nextRule != null && (!this.ruleAgendaItem.getRule().getAgendaGroup().equals(nextRule.getAgendaGroup()) || !this.isHighestSalience(nextRule, salience)) || fireLimit >= 0 && localFireCount + fireCount >= fireLimit;
    }

    public boolean isHighestSalience(RuleAgendaItem nextRule, int currentSalience) {
        return nextRule.getSalience() <= currentSalience;
    }

    public LeftTupleList getLeftTupleList() {
        return this.tupleList;
    }

    public void addLeftTuple(LeftTuple leftTuple) {
        ((AgendaItem)((Object)leftTuple)).setQueued(true);
        this.tupleList.add(leftTuple);
        if (this.queue != null) {
            this.addQueuedLeftTuple(leftTuple);
        }
    }

    public void addQueuedLeftTuple(LeftTuple leftTuple) {
        int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
        this.queue.enqueue((Activation)((Object)leftTuple));
        this.updateSalience(currentSalience);
    }

    public void removeLeftTuple(LeftTuple leftTuple) {
        ((AgendaItem)((Object)leftTuple)).setQueued(false);
        this.tupleList.remove(leftTuple);
        if (this.queue != null) {
            this.removeQueuedLeftTuple(leftTuple);
        }
    }

    public void removeQueuedLeftTuple(LeftTuple leftTuple) {
        int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
        this.queue.dequeue(((Activation)((Object)leftTuple)).getQueueIndex());
        this.updateSalience(currentSalience);
    }

    public void updateLeftTuple(RuleTerminalNodeLeftTuple leftTuple, int salience, PropagationContext pctx) {
        if (salience != leftTuple.getSalience()) {
            int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
            leftTuple.dequeue();
            this.queue.enqueue(leftTuple);
            this.updateSalience(currentSalience);
        }
        leftTuple.update(salience, pctx);
    }

    private void updateSalience(int currentSalience) {
        int newSalience = this.queue.peek().getSalience();
        if (currentSalience != newSalience) {
            this.ruleAgendaItem.remove();
        }
        if (!this.ruleAgendaItem.isQueued()) {
            this.ruleAgendaItem.setSalience(newSalience);
            this.ruleAgendaItem.getAgendaGroup().add(this.ruleAgendaItem);
        }
    }

    public void cancel(InternalWorkingMemory wm, EventSupport es) {
        while (!this.tupleList.isEmpty()) {
            RuleTerminalNodeLeftTuple rtnLt = (RuleTerminalNodeLeftTuple)this.tupleList.removeFirst();
            if (this.queue != null) {
                this.queue.dequeue(rtnLt.getQueueIndex());
            }
            es.getAgendaEventSupport().fireActivationCancelled(rtnLt, wm, MatchCancelledCause.CLEAR);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDeclarativeAgendaEnabled() {
        return this.declarativeAgendaEnabled;
    }

    public static class SalienceComparator
    implements Comparator {
        public static final SalienceComparator INSTANCE = new SalienceComparator();

        public int compare(Object existing, Object adding) {
            int s2;
            RuleTerminalNodeLeftTuple rtnLt1 = (RuleTerminalNodeLeftTuple)existing;
            RuleTerminalNodeLeftTuple rtnLt2 = (RuleTerminalNodeLeftTuple)adding;
            int s1 = rtnLt1.getSalience();
            if (s1 > (s2 = rtnLt2.getSalience())) {
                return 1;
            }
            if (s1 < s2) {
                return -1;
            }
            return 0;
        }
    }
}

