/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleIterator;
import org.drools.core.common.Memory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.TupleStartEqualsConstraint;
import org.drools.core.common.UpdateContext;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.LeftTupleSourceUtils;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.NodeSet;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;

public class QueryRiaFixerNode
extends LeftTupleSource
implements LeftTupleSinkNode {
    private static final long serialVersionUID = 510L;
    protected boolean tupleMemoryEnabled;
    private BetaNode betaNode;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public QueryRiaFixerNode() {
    }

    public QueryRiaFixerNode(int id, LeftTupleSource tupleSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.setLeftTupleSource(tupleSource);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.betaNode = (BetaNode)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.betaNode);
        out.writeBoolean(this.tupleMemoryEnabled);
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleSourceUtils.doModifyLeftTuple(factHandle, modifyPreviousTuples, context, workingMemory, this, this.getLeftInputOtnId(), this.getLeftInferredMask());
    }

    public BetaNode getBetaNode() {
        return this.betaNode;
    }

    @Override
    public void addTupleSink(LeftTupleSink tupleSink, BuildContext context) {
        this.betaNode = (BetaNode)tupleSink;
    }

    @Override
    public void attach(BuildContext context) {
        this.leftInput.addTupleSink(this, context);
        if (context == null || context.getRuleBase().getConfiguration().isPhreakEnabled()) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextFactory pctxFactory = context.getComponentFactory().getPropagationContextFactory();
            PropagationContext propagationContext = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.leftInput.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        context.getQueue2().addLast(new QueryRiaFixerNodeFixer(context, leftTuple, false, this.betaNode));
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        context.getQueue2().addLast(new QueryRiaFixerNodeFixer(context, leftTuple, true, this.betaNode));
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        context.getQueue2().addLast(new QueryRiaFixerNodeFixer(context, leftTuple, false, this.betaNode));
    }

    @Override
    public String toString() {
        return "[RiaQueryFixerNode: ]";
    }

    @Override
    public int hashCode() {
        return this.leftInput.hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        Iterator<LeftTuple> it = LeftTupleIterator.iterator(workingMemory, this);
        LeftTuple leftTuple = it.next();
        while (leftTuple != null) {
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                RightTuple rightParent = childLeftTuple.getRightParent();
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, rightParent, childLeftTuple, null, sink, true), context, workingMemory);
                while (childLeftTuple != null && childLeftTuple.getRightParent() == rightParent) {
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
            }
            leftTuple = it.next();
        }
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
        }
    }

    @Override
    protected void doCollectAncestors(NodeSet nodeSet) {
        this.getLeftTupleSource().collectAncestors(nodeSet);
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 141;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return this.betaNode.createLeftTuple(factHandle, this.betaNode, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        return this.betaNode.createLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return this.betaNode.createLeftTuple(leftTuple, this.betaNode, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return this.betaNode.createLeftTuple(leftTuple, rightTuple, (LeftTupleSink)this.betaNode);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return this.betaNode.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, this.betaNode, leftTupleMemoryEnabled);
    }

    @Override
    public boolean isInUse() {
        return this.betaNode != null;
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        return null;
    }

    @Override
    public void removeTupleSink(LeftTupleSink tupleSink) {
        if (tupleSink != this.betaNode) {
            throw new IllegalArgumentException(tupleSink + " is not a sink for this node");
        }
        this.betaNode = null;
    }

    public static class QueryRiaFixerNodeFixer
    implements WorkingMemoryAction {
        private PropagationContext context;
        private LeftTuple leftTuple;
        private BetaNode node;
        private boolean retract;

        public QueryRiaFixerNodeFixer(PropagationContext context) {
            this.context = context;
        }

        public QueryRiaFixerNodeFixer(PropagationContext context, LeftTuple leftTuple, boolean retract, BetaNode node) {
            this.context = context;
            this.leftTuple = leftTuple;
            this.retract = retract;
            this.node = node;
        }

        public QueryRiaFixerNodeFixer(MarshallerReaderContext context) throws IOException {
            throw new UnsupportedOperationException("Should not be present in network on serialisation");
        }

        @Override
        public void write(MarshallerWriteContext context) throws IOException {
            throw new UnsupportedOperationException("Should not be present in network on serialisation");
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) throws IOException {
            throw new UnsupportedOperationException("Should not be present in network on serialisation");
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            this.leftTuple.setLeftTupleSink(this.node);
            if (this.leftTuple.getFirstChild() == null) {
                this.node.assertLeftTuple(this.leftTuple, this.context, workingMemory);
            } else if (this.retract) {
                this.node.getSinkPropagator().propagateRetractLeftTuple(this.leftTuple, this.context, workingMemory);
            } else {
                this.node.getSinkPropagator().propagateModifyChildLeftTuple(this.leftTuple, this.context, workingMemory, true);
            }
            if (this.leftTuple.getLeftParent() == null) {
                Memory node = workingMemory.getNodeMemory(this.node);
                RightTupleMemory rightMemory = null;
                if (node instanceof BetaMemory) {
                    rightMemory = ((BetaMemory)node).getRightTupleMemory();
                } else if (node instanceof AccumulateNode.AccumulateMemory) {
                    rightMemory = ((AccumulateNode.AccumulateMemory)node).betaMemory.getRightTupleMemory();
                }
                TupleStartEqualsConstraint constraint = TupleStartEqualsConstraint.getInstance();
                TupleStartEqualsConstraint.TupleStartEqualsConstraintContextEntry contextEntry = new TupleStartEqualsConstraint.TupleStartEqualsConstraintContextEntry();
                contextEntry.updateFromTuple(workingMemory, this.leftTuple);
                FastIterator rightIt = rightMemory.fastIterator();
                RightTuple temp = null;
                RightTuple rightTuple = rightMemory.getFirst(this.leftTuple, (InternalFactHandle)this.context.getFactHandle(), rightIt);
                while (rightTuple != null) {
                    temp = (RightTuple)rightIt.next(rightTuple);
                    if (constraint.isAllowedCachedLeft(contextEntry, rightTuple.getFactHandle())) {
                        rightMemory.remove(rightTuple);
                    }
                    rightTuple = temp;
                }
            }
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }

        public String toString() {
            return "[QueryRiaFixerNodeFixer leftTuple=" + this.leftTuple + ",\n        retract=" + this.retract + "]\n";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }
}

