/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.TerminalNode;

public class RiaPathMemory
extends PathMemory {
    private RightInputAdapterNode riaNode;
    private String terminalNodes;

    public RiaPathMemory(RightInputAdapterNode riaNode) {
        super(riaNode);
        this.riaNode = riaNode;
    }

    public RightInputAdapterNode getRightInputAdapterNode() {
        return this.riaNode;
    }

    @Override
    public void doLinkRule(InternalWorkingMemory wm) {
        this.riaNode.getSinkPropagator().doLinkRiaNode(wm);
    }

    @Override
    public void doUnlinkRule(InternalWorkingMemory wm) {
        this.riaNode.getSinkPropagator().doUnlinkRiaNode(wm);
    }

    @Override
    public short getNodeType() {
        return 71;
    }

    public void updateRuleTerminalNodes() {
        ArrayList<String> terminalNodeNames = new ArrayList<String>();
        for (ObjectSink osink : this.riaNode.getSinkPropagator().getSinks()) {
            for (LeftTupleSink ltsink : ((BetaNode)osink).getSinkPropagator().getSinks()) {
                this.findAndAddTN(ltsink, terminalNodeNames);
            }
        }
        StringBuilder sbuilder = new StringBuilder();
        boolean first = true;
        for (String name : terminalNodeNames) {
            if (!first) {
                sbuilder.append(", ");
            }
            sbuilder.append(name);
            first = false;
        }
        this.terminalNodes = sbuilder.toString();
    }

    public void findAndAddTN(LeftTupleSink ltsink, List<String> terminalNodeNames) {
        if (NodeTypeEnums.isTerminalNode(ltsink)) {
            terminalNodeNames.add(((TerminalNode)ltsink).getRule().getName());
        } else if (ltsink.getType() != 71) {
            for (LeftTupleSink childLtSink : ((LeftTupleSource)((Object)ltsink)).getSinkPropagator().getSinks()) {
                this.findAndAddTN(childLtSink, terminalNodeNames);
            }
        }
    }

    @Override
    public String toString() {
        if (this.terminalNodes == null) {
            this.updateRuleTerminalNodes();
        }
        return "[RiaMem " + this.terminalNodes + "]";
    }
}

