/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.eclipse.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.jbpm.eclipse.preferences.JBPMRuntimeDialog;
import org.jbpm.eclipse.util.JBPMRuntime;
import org.jbpm.eclipse.util.JBPMRuntimeManager;

public class JBPMRuntimesBlock
implements ISelectionProvider {
    private Composite fControl;
    private List<JBPMRuntime> jbpmRuntimes = new ArrayList<JBPMRuntime>();
    private CheckboxTableViewer jbpmRuntimesList;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private ListenerList fSelectionListeners = new ListenerList();
    private ISelection fPrevSelection = new StructuredSelection();
    private Table fTable;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.jbpmRuntimesList.getCheckedElements());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            Object runtime = ((IStructuredSelection)selection).getFirstElement();
            if (runtime == null) {
                this.jbpmRuntimesList.setCheckedElements(new Object[0]);
            } else {
                this.jbpmRuntimesList.setCheckedElements(new Object[]{runtime});
                this.jbpmRuntimesList.reveal(runtime);
            }
            this.fireSelectionChanged();
        }
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] listeners = this.fSelectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    public void createControl(Composite ancestor) {
        Composite parent;
        Font font = ancestor.getFont();
        this.fControl = parent = SWTFactory.createComposite((Composite)ancestor, (Font)font, (int)2, (int)1, (int)1808);
        SWTFactory.createLabel((Composite)parent, (String)"Installed jBPM Runtimes", (int)2);
        this.fTable = new Table(parent, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 350;
        this.fTable.setLayoutData((Object)gd);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn column = new TableColumn(this.fTable, 0);
        column.setText("Name");
        int defaultwidth = 176;
        column.setWidth(defaultwidth);
        column = new TableColumn(this.fTable, 0);
        column.setText("Location");
        column.setWidth(defaultwidth);
        this.jbpmRuntimesList = new CheckboxTableViewer(this.fTable);
        this.jbpmRuntimesList.setLabelProvider((IBaseLabelProvider)new JBPMRuntimesLabelProvider());
        this.jbpmRuntimesList.setContentProvider((IContentProvider)new JBPMRuntimesContentProvider());
        this.jbpmRuntimesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                JBPMRuntimesBlock.this.enableButtons();
            }
        });
        this.jbpmRuntimesList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    JBPMRuntimesBlock.this.setDefaultJBPMRuntime((JBPMRuntime)event.getElement());
                } else {
                    JBPMRuntimesBlock.this.setDefaultJBPMRuntime(null);
                }
            }
        });
        this.jbpmRuntimesList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!JBPMRuntimesBlock.this.jbpmRuntimesList.getSelection().isEmpty()) {
                    JBPMRuntimesBlock.this.editJBPMRuntime();
                }
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && JBPMRuntimesBlock.this.fRemoveButton.isEnabled()) {
                    JBPMRuntimesBlock.this.removeJBPMRuntimes();
                }
            }
        });
        Composite buttons = SWTFactory.createComposite((Composite)parent, (Font)font, (int)1, (int)1, (int)2, (int)0, (int)0);
        this.fAddButton = SWTFactory.createPushButton((Composite)buttons, (String)"Add...", null);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                JBPMRuntimesBlock.this.addJBPMRuntime();
            }
        });
        this.fEditButton = SWTFactory.createPushButton((Composite)buttons, (String)"Edit...", null);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                JBPMRuntimesBlock.this.editJBPMRuntime();
            }
        });
        this.fRemoveButton = SWTFactory.createPushButton((Composite)buttons, (String)"Remove", null);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                JBPMRuntimesBlock.this.removeJBPMRuntimes();
            }
        });
        SWTFactory.createVerticalSpacer((Composite)parent, (int)1);
        this.enableButtons();
        this.fAddButton.setEnabled(true);
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.jbpmRuntimesList.getSelection();
        int selectionCount = selection.size();
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fRemoveButton.setEnabled(selectionCount > 0);
    }

    public Control getControl() {
        return this.fControl;
    }

    public void setJBPMRuntimes(JBPMRuntime[] runtimes) {
        this.jbpmRuntimes.clear();
        int i = 0;
        while (i < runtimes.length) {
            this.jbpmRuntimes.add(runtimes[i]);
            ++i;
        }
        this.jbpmRuntimesList.setInput(this.jbpmRuntimes);
        this.jbpmRuntimesList.refresh();
    }

    public JBPMRuntime[] getJBPMRuntimes() {
        JBPMRuntime selected = this.getDefaultJBPMRuntime();
        for (JBPMRuntime runtime : this.jbpmRuntimes) {
            runtime.setDefault(runtime.equals(selected));
        }
        return this.jbpmRuntimes.toArray(new JBPMRuntime[this.jbpmRuntimes.size()]);
    }

    private void addJBPMRuntime() {
        JBPMRuntime result;
        JBPMRuntimeDialog dialog = new JBPMRuntimeDialog(this.getShell(), this.jbpmRuntimes);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
            JBPMRuntimeManager.recognizeJars(result);
            this.jbpmRuntimes.add(result);
            this.jbpmRuntimesList.refresh();
            this.jbpmRuntimesList.setSelection((ISelection)new StructuredSelection((Object)result));
        }
    }

    private void editJBPMRuntime() {
        JBPMRuntime result;
        IStructuredSelection selection = (IStructuredSelection)this.jbpmRuntimesList.getSelection();
        JBPMRuntime runtime = (JBPMRuntime)selection.getFirstElement();
        if (runtime == null) {
            return;
        }
        JBPMRuntimeDialog dialog = new JBPMRuntimeDialog(this.getShell(), this.jbpmRuntimes);
        dialog.setJBPMRuntime(runtime);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
            JBPMRuntimeManager.recognizeJars(result);
            int index = this.jbpmRuntimes.indexOf(runtime);
            this.jbpmRuntimes.remove(index);
            this.jbpmRuntimes.add(index, result);
            this.jbpmRuntimesList.refresh();
            this.jbpmRuntimesList.setSelection((ISelection)new StructuredSelection((Object)result));
        }
    }

    private void removeJBPMRuntimes() {
        IStructuredSelection selection = (IStructuredSelection)this.jbpmRuntimesList.getSelection();
        JBPMRuntime[] runtimes = new JBPMRuntime[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            runtimes[i] = (JBPMRuntime)iter.next();
            ++i;
        }
        this.removeJBPMRuntimes(runtimes);
    }

    public void removeJBPMRuntimes(JBPMRuntime[] runtimes) {
        IStructuredSelection prev = (IStructuredSelection)this.getSelection();
        int i = 0;
        while (i < runtimes.length) {
            this.jbpmRuntimes.remove(runtimes[i]);
            ++i;
        }
        this.jbpmRuntimesList.refresh();
        IStructuredSelection curr = (IStructuredSelection)this.getSelection();
        if (!curr.equals(prev)) {
            runtimes = this.getJBPMRuntimes();
            if (curr.size() == 0 && runtimes.length == 1) {
                this.setSelection((ISelection)new StructuredSelection((Object)runtimes[0]));
            } else {
                this.fireSelectionChanged();
            }
        }
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public void setDefaultJBPMRuntime(JBPMRuntime runtime) {
        if (runtime == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)runtime));
        }
    }

    public JBPMRuntime getDefaultJBPMRuntime() {
        Object[] objects = this.jbpmRuntimesList.getCheckedElements();
        if (objects.length == 0) {
            return null;
        }
        return (JBPMRuntime)objects[0];
    }

    class JBPMRuntimesContentProvider
    implements IStructuredContentProvider {
        JBPMRuntimesContentProvider() {
        }

        public Object[] getElements(Object input) {
            return JBPMRuntimesBlock.this.jbpmRuntimes.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class JBPMRuntimesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        JBPMRuntimesLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof JBPMRuntime) {
                JBPMRuntime runtime = (JBPMRuntime)element;
                switch (columnIndex) {
                    case 0: {
                        return runtime.getName();
                    }
                    case 1: {
                        return runtime.getPath();
                    }
                }
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

