/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.ElementEditor;
import org.eclipse.webdav.dom.MalformedElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertyBehavior
extends ElementEditor {
    protected static final String[] childNames = new String[]{"omit", "keepalive"};
    public static String[] fgNamesOmit = new String[]{"omit"};
    public static String[] fgNamesKeepAlive = new String[]{"keepalive"};

    public PropertyBehavior(Element root) throws MalformedElementException {
        super(root, "propertybehavior");
    }

    public void addProperty(String propertyHref) {
        Assert.isNotNull(propertyHref);
        Assert.isTrue(PropertyBehavior.getFirstChild(this.root, "omit") == null);
        Element keepalive = PropertyBehavior.getFirstChild(this.root, "keepalive");
        if (keepalive == null) {
            keepalive = PropertyBehavior.addChild(this.root, "keepalive", fgNamesKeepAlive, true);
        } else {
            Assert.isTrue(!"*".equals(PropertyBehavior.getFirstText(keepalive)));
        }
        PropertyBehavior.addChild(keepalive, "href", PropertyBehavior.encodeHref(propertyHref), new String[]{"href"}, false);
    }

    public static PropertyBehavior create(Document document) {
        Assert.isNotNull(document);
        Assert.isTrue(document.getOwnerDocument() == null);
        Element element = PropertyBehavior.create(document, "propertybehavior");
        PropertyBehavior result = null;
        try {
            result = new PropertyBehavior(element);
        }
        catch (MalformedElementException malformedElementException) {
            Assert.isTrue(false, Policy.bind("assert.internalError"));
        }
        return result;
    }

    public Enumeration getProperties() throws MalformedElementException {
        Element keepalive = PropertyBehavior.getFirstChild(this.root, "keepalive");
        PropertyBehavior.ensureNotNull(Policy.bind("ensure.missingKeealiveElmt"), keepalive);
        PropertyBehavior.ensure(!"*".equals(PropertyBehavior.getFirstText(keepalive)), Policy.bind("ensure.wrongForm"));
        Element firstHref = PropertyBehavior.getFirstChild(keepalive, "href");
        PropertyBehavior.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), firstHref);
        Enumeration e = new Enumeration(firstHref){
            Element currentHref;
            {
                this.currentHref = element;
            }

            @Override
            public boolean hasMoreElements() {
                return this.currentHref != null;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String href = PropertyBehavior.getFirstText(this.currentHref);
                this.currentHref = PropertyBehavior.getTwin(this.currentHref, true);
                return PropertyBehavior.decodeHref(href);
            }
        };
        return e;
    }

    public boolean isKeepAllAlive() throws MalformedElementException {
        Element child = PropertyBehavior.getFirstChild(this.root, childNames);
        PropertyBehavior.ensureNotNull(Policy.bind("ensure.expectingOmitOrKeepaliveElmt"), child);
        boolean isKeepAllAlive = false;
        if (PropertyBehavior.isDAVElement(child, "keepalive")) {
            isKeepAllAlive = "*".equals(PropertyBehavior.getFirstText(child));
            PropertyBehavior.ensureNull(Policy.bind("ensure.conflictingHrefElmt"), PropertyBehavior.getFirstChild(child, "href"));
        }
        child = PropertyBehavior.getNextSibling(child, childNames);
        PropertyBehavior.ensureNull(Policy.bind("ensure.conflictingOmitOrKeepaliveElmt"), child);
        return isKeepAllAlive;
    }

    public boolean isOmit() throws MalformedElementException {
        Element child = PropertyBehavior.getFirstChild(this.root, childNames);
        PropertyBehavior.ensureNotNull(Policy.bind("ensure.expectingOmitOrKeepaliveElmt"), child);
        boolean isOmit = PropertyBehavior.isDAVElement(child, "omit");
        child = PropertyBehavior.getNextSibling(child, childNames);
        PropertyBehavior.ensureNull(Policy.bind("ensure.conflictingOmitOrKeepaliveElmt"), child);
        return isOmit;
    }

    public void setIsKeepAllAlive(boolean isKeepAllAlive) {
        Element child = PropertyBehavior.getFirstChild(this.root, childNames);
        boolean isAlreadyKeepAllAlive = false;
        if (PropertyBehavior.isDAVElement(child, "keepalive")) {
            isAlreadyKeepAllAlive = "*".equals(PropertyBehavior.getFirstText(child));
        }
        if (isKeepAllAlive) {
            if (!isAlreadyKeepAllAlive) {
                if (child != null) {
                    this.root.removeChild(child);
                }
                PropertyBehavior.appendChild(this.root, "keepalive", "*");
            }
        } else if (isAlreadyKeepAllAlive) {
            this.root.removeChild(child);
        }
    }

    public void setIsOmit(boolean isOmit) {
        Element child = PropertyBehavior.getFirstChild(this.root, childNames);
        boolean isAlreadyOmit = PropertyBehavior.isDAVElement(child, "omit");
        if (isOmit) {
            if (!isAlreadyOmit) {
                if (child != null) {
                    this.root.removeChild(child);
                }
                PropertyBehavior.appendChild(this.root, "omit");
            }
        } else if (isAlreadyOmit) {
            this.root.removeChild(child);
        }
    }
}

