/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.util.Enumeration;
import org.eclipse.webdav.dom.QualifiedName;
import org.eclipse.webdav.internal.kernel.DocumentFactory;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.WebDAVConstants;
import org.eclipse.webdav.internal.kernel.utils.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementHelper
implements WebDAVConstants {
    protected Document nodeFactory;
    protected static final String DAV_PREFIX = "D";
    protected static final String NS_SEPARATOR = ":";
    protected static final String DAV_NS_ATTRIB = "xmlns:D";

    public ElementHelper() {
        DocumentFactory factory = new DocumentFactory();
        this.nodeFactory = factory.newDocument();
    }

    public String extractText(Element element) {
        NodeList childNodes = element.getChildNodes();
        Assert.isTrue(childNodes.getLength() == 1, Policy.bind("error.requireElementWithSingleChild"));
        Node child = childNodes.item(0);
        Assert.isTrue(child instanceof Text, Policy.bind("error.extractFromElementWithoutText"));
        return ((Text)child).getData();
    }

    public Element newDAVElement(QualifiedName name) {
        Assert.isTrue(name.getQualifier().equals("DAV:"), Policy.bind("error.davElementsNeedQualifier"));
        Element element = this.nodeFactory.createElement("D:" + name.getLocalName());
        element.setAttribute(DAV_NS_ATTRIB, "DAV:");
        return element;
    }

    public Element newDAVElementSet(QualifiedName setName, QualifiedName memberName, Enumeration memberEnum) {
        Element setElement = this.newDAVElement(setName);
        while (memberEnum.hasMoreElements()) {
            String member = (String)memberEnum.nextElement();
            Element memberElement = this.newDAVTextElement(memberName, member);
            setElement.appendChild(memberElement);
        }
        return setElement;
    }

    public Element newDAVProperty(QualifiedName name, String value) {
        Element element = this.newDAVElement(name);
        element.appendChild(this.nodeFactory.createTextNode(value));
        return element;
    }

    public Element newDAVProperty(QualifiedName name, Element value) {
        Element element = this.newDAVElement(name);
        element.appendChild(value);
        return element;
    }

    public Element newDAVTextElement(QualifiedName name, String value) {
        Element element = this.newDAVElement(name);
        element.appendChild(this.nodeFactory.createTextNode(value));
        return element;
    }

    public Element newTextElement(String name, String value) {
        Element element = this.nodeFactory.createElement(name);
        element.appendChild(this.nodeFactory.createTextNode(value));
        return element;
    }
}

