/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Stack;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.Process;
import org.jbpm.process.core.context.exception.CompensationScope;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.context.exception.CompensationScopeInstance;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.ProcessInstance;

class CompensationEventListener
implements EventListener {
    private WorkflowProcessInstanceImpl instance;
    private final String[] eventTypes = new String[]{"Compensation"};

    public CompensationEventListener(WorkflowProcessInstanceImpl instance) {
        this.instance = instance;
    }

    private org.jbpm.process.instance.ProcessInstance getProcessInstance() {
        return this.instance;
    }

    public void signalEvent(String compensationType, Object activityRefStr) {
        String activityRef;
        if (activityRefStr == null || !(activityRefStr instanceof String)) {
            throw new WorkflowRuntimeException(null, (ProcessInstance)this.getProcessInstance(), "Compensation can only be triggered with String events, not an event of type " + activityRefStr == null ? "null" : activityRefStr.getClass().getSimpleName());
        }
        String toCompensateNodeId = activityRef = (String)activityRefStr;
        boolean generalCompensation = false;
        if (activityRef.startsWith("general:")) {
            toCompensateNodeId = activityRef.substring("general:".length());
            generalCompensation = true;
        }
        Process process = (Process)this.instance.getProcess();
        Node toCompensateNode = null;
        ContextContainer compensationScopeContainer = null;
        if (generalCompensation) {
            compensationScopeContainer = toCompensateNodeId.equals(this.instance.getProcessId()) ? process : (ContextContainer)this.findNode(toCompensateNodeId);
        } else {
            toCompensateNode = this.findNode(toCompensateNodeId);
        }
        if (toCompensateNode != null || compensationScopeContainer != null) {
            CompensationScopeInstance scopeInstance;
            CompensationScope compensationScope = null;
            compensationScope = compensationScopeContainer != null ? (CompensationScope)compensationScopeContainer.getDefaultContext("CompensationScope") : (CompensationScope)((NodeImpl)toCompensateNode).resolveContext("CompensationScope", toCompensateNodeId);
            assert (compensationScope != null) : "Compensation scope for node [" + toCompensateNodeId + "] could not be found!";
            if (compensationScope.getContextContainerId().equals(process.getId())) {
                scopeInstance = (CompensationScopeInstance)this.instance.getContextInstance(compensationScope);
            } else {
                Stack<NodeInstance> generatedInstances = toCompensateNode == null ? this.createNodeInstanceContainers((Node)compensationScopeContainer, true) : this.createNodeInstanceContainers(toCompensateNode, false);
                NodeInstance nodeInstanceContainer = generatedInstances.peek();
                scopeInstance = (CompensationScopeInstance)((ContextInstanceContainer)((Object)nodeInstanceContainer)).getContextInstance(compensationScope);
                scopeInstance.addCompensationInstances(generatedInstances);
            }
            scopeInstance.handleException(activityRef, null);
        }
    }

    private Node findNode(String nodeId) {
        Node found = null;
        LinkedList<Node> allProcessNodes = new LinkedList<Node>();
        allProcessNodes.addAll(Arrays.asList(this.instance.getNodeContainer().getNodes()));
        while (!allProcessNodes.isEmpty()) {
            Node node = (Node)allProcessNodes.poll();
            if (nodeId.equals(node.getMetaData().get("UniqueId"))) {
                found = node;
                break;
            }
            if (!(node instanceof NodeContainer)) continue;
            allProcessNodes.addAll(Arrays.asList(((NodeContainer)node).getNodes()));
        }
        return found;
    }

    private Stack<NodeInstance> createNodeInstanceContainers(Node toCompensateNode, boolean generalCompensation) {
        NodeInstanceContainer parentInstance;
        Stack<NodeContainer> nestedNodes = new Stack<NodeContainer>();
        Stack<NodeInstance> generatedInstances = new Stack<NodeInstance>();
        NodeContainer parentContainer = toCompensateNode.getNodeContainer();
        while (!(parentContainer instanceof RuleFlowProcess)) {
            nestedNodes.add(parentContainer);
            parentContainer = ((Node)parentContainer).getNodeContainer();
        }
        if (nestedNodes.isEmpty()) {
            parentInstance = (NodeInstanceContainer)((Object)this.getProcessInstance());
        } else {
            parentInstance = (NodeInstanceContainer)((Object)((WorkflowProcessInstanceImpl)this.getProcessInstance()).getNodeInstance((Node)nestedNodes.pop()));
            generatedInstances.add((NodeInstance)((Object)parentInstance));
        }
        NodeInstanceContainer childInstance = parentInstance;
        while (!nestedNodes.isEmpty()) {
            childInstance = (NodeInstanceContainer)((Object)parentInstance.getNodeInstance((Node)nestedNodes.pop()));
            assert (childInstance instanceof CompositeNodeInstance) : "A node with child nodes should end up creating a CompositeNodeInstance type.";
            generatedInstances.add((NodeInstance)((Object)childInstance));
            parentInstance = (CompositeContextNodeInstance)childInstance;
        }
        if (generalCompensation) {
            childInstance = (NodeInstanceContainer)((Object)parentInstance.getNodeInstance(toCompensateNode));
            generatedInstances.add((NodeInstance)((Object)childInstance));
        }
        return generatedInstances;
    }

    public String[] getEventTypes() {
        return this.eventTypes;
    }
}

