/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.AcceptsReadAccessor;
import org.drools.core.spi.CompiledInvoker;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ReadAccessor;
import org.drools.core.spi.Restriction;
import org.drools.core.spi.ReturnValueExpression;
import org.drools.core.spi.Tuple;
import org.drools.core.spi.Wireable;
import org.kie.internal.security.KiePolicyHelper;

public class ReturnValueRestriction
implements Restriction,
AcceptsReadAccessor,
Wireable {
    private static final long serialVersionUID = 510L;
    private ReturnValueExpression expression;
    private String[] requiredGlobals;
    private Declaration[] requiredDeclarations;
    private Declaration[] previousDeclarations;
    private Declaration[] localDeclarations;
    private Evaluator evaluator;
    private InternalReadAccessor readAccessor;
    private static final Declaration[] noRequiredDeclarations = new Declaration[0];
    private static final String[] noRequiredGlobals = new String[0];
    private List<ReturnValueRestriction> cloned = Collections.emptyList();

    public ReturnValueRestriction() {
    }

    public ReturnValueRestriction(InternalReadAccessor fieldExtractor, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] requiredGlobals, Evaluator evaluator) {
        this(fieldExtractor, null, previousDeclarations, localDeclarations, requiredGlobals, evaluator);
    }

    public ReturnValueRestriction(InternalReadAccessor fieldExtractor, ReturnValueExpression returnValueExpression, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] requiredGlobals, Evaluator evaluator) {
        this.expression = returnValueExpression;
        this.readAccessor = fieldExtractor;
        this.previousDeclarations = previousDeclarations != null ? previousDeclarations : noRequiredDeclarations;
        this.localDeclarations = localDeclarations != null ? localDeclarations : noRequiredDeclarations;
        this.requiredGlobals = requiredGlobals != null ? requiredGlobals : noRequiredGlobals;
        this.evaluator = evaluator;
        this.requiredDeclarations = new Declaration[this.previousDeclarations.length + this.localDeclarations.length];
        System.arraycopy(this.previousDeclarations, 0, this.requiredDeclarations, 0, this.previousDeclarations.length);
        System.arraycopy(this.localDeclarations, 0, this.requiredDeclarations, this.previousDeclarations.length, this.localDeclarations.length);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expression = (ReturnValueExpression)in.readObject();
        this.requiredGlobals = (String[])in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
        this.previousDeclarations = (Declaration[])in.readObject();
        this.localDeclarations = (Declaration[])in.readObject();
        this.evaluator = (Evaluator)in.readObject();
        this.readAccessor = (InternalReadAccessor)in.readObject();
        this.cloned = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.expression instanceof CompiledInvoker) {
            out.writeObject(null);
        } else {
            out.writeObject(this.expression);
        }
        out.writeObject(this.requiredGlobals);
        out.writeObject(this.requiredDeclarations);
        out.writeObject(this.previousDeclarations);
        out.writeObject(this.localDeclarations);
        out.writeObject(this.evaluator);
        out.writeObject(this.readAccessor);
        out.writeObject(this.cloned);
    }

    @Override
    public void setReadAccessor(InternalReadAccessor readAccessor) {
        this.readAccessor = readAccessor;
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public Declaration[] getPreviousDeclarations() {
        return this.previousDeclarations;
    }

    public Declaration[] getLocalDeclarations() {
        return this.localDeclarations;
    }

    public String[] getRequiredGlobals() {
        return this.requiredGlobals;
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        int i;
        for (i = 0; i < this.requiredDeclarations.length; ++i) {
            if (!this.requiredDeclarations[i].equals(oldDecl)) continue;
            this.requiredDeclarations[i] = newDecl;
        }
        for (i = 0; i < this.previousDeclarations.length; ++i) {
            if (!this.previousDeclarations[i].equals(oldDecl)) continue;
            this.previousDeclarations[i] = newDecl;
        }
        for (i = 0; i < this.localDeclarations.length; ++i) {
            if (!this.localDeclarations[i].equals(oldDecl)) continue;
            this.localDeclarations[i] = newDecl;
        }
        this.expression.replaceDeclaration(oldDecl, newDecl);
    }

    @Override
    public void wire(Object object) {
        this.setReturnValueExpression(KiePolicyHelper.isPolicyEnabled() ? new ReturnValueExpression.SafeReturnValueExpression((ReturnValueExpression)object) : (ReturnValueExpression)object);
        for (ReturnValueRestriction clone : this.cloned) {
            clone.wire(object);
        }
    }

    public void setReturnValueExpression(ReturnValueExpression expression) {
        this.expression = expression;
    }

    public ReturnValueExpression getExpression() {
        return this.expression;
    }

    @Override
    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public boolean isTemporal() {
        return this.evaluator.isTemporal();
    }

    public boolean isAllowed(InternalReadAccessor readAccessor, InternalFactHandle handle, Tuple tuple, WorkingMemory workingMemory, ContextEntry context) {
        try {
            return this.evaluator.evaluate((InternalWorkingMemory)workingMemory, this.readAccessor, handle, this.expression.evaluate(handle.getObject(), tuple, this.previousDeclarations, this.localDeclarations, workingMemory, ((ReturnValueContextEntry)context).dialectContext));
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    @Override
    public boolean isAllowed(InternalReadAccessor extractor, InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        try {
            ReturnValueContextEntry ctx = (ReturnValueContextEntry)context;
            FieldValue value = this.expression.evaluate(handle.getObject(), null, this.previousDeclarations, this.localDeclarations, workingMemory, ctx.dialectContext);
            return this.evaluator.evaluate(workingMemory, this.readAccessor, handle, value);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        try {
            ReturnValueContextEntry ctx = (ReturnValueContextEntry)context;
            FieldValue value = this.expression.evaluate(handle.getObject(), ctx.leftTuple, this.previousDeclarations, this.localDeclarations, ctx.workingMemory, ctx.dialectContext);
            return this.evaluator.evaluate(ctx.workingMemory, this.readAccessor, handle, value);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    @Override
    public boolean isAllowedCachedRight(LeftTuple tuple, ContextEntry context) {
        try {
            ReturnValueContextEntry ctx = (ReturnValueContextEntry)context;
            FieldValue value = this.expression.evaluate(ctx.handle.getObject(), tuple, this.previousDeclarations, this.localDeclarations, ctx.workingMemory, ctx.dialectContext);
            return this.evaluator.evaluate(ctx.workingMemory, this.readAccessor, ctx.handle, value);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.evaluator.hashCode();
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        result = 31 * result + ReturnValueRestriction.hashCode(this.localDeclarations);
        result = 31 * result + ReturnValueRestriction.hashCode(this.previousDeclarations);
        result = 31 * result + ReturnValueRestriction.hashCode(this.requiredGlobals);
        return result;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != ReturnValueRestriction.class) {
            return false;
        }
        ReturnValueRestriction other = (ReturnValueRestriction)object;
        if (this.localDeclarations.length != other.localDeclarations.length) {
            return false;
        }
        if (this.previousDeclarations.length != other.previousDeclarations.length) {
            return false;
        }
        if (this.requiredGlobals.length != other.requiredGlobals.length) {
            return false;
        }
        if (!Arrays.equals(this.localDeclarations, other.localDeclarations)) {
            return false;
        }
        if (!Arrays.equals(this.previousDeclarations, other.previousDeclarations)) {
            return false;
        }
        return Arrays.equals(this.requiredGlobals, other.requiredGlobals) && this.evaluator.equals(other.evaluator) && this.expression.equals(other.expression);
    }

    private static int hashCode(Object[] array) {
        int PRIME = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (Object anArray : array) {
            result = 31 * result + (anArray == null ? 0 : anArray.hashCode());
        }
        return result;
    }

    @Override
    public ContextEntry createContextEntry() {
        ReturnValueContextEntry ctx = new ReturnValueContextEntry(this.readAccessor, this.previousDeclarations, this.localDeclarations);
        ctx.dialectContext = this.expression.createContext();
        return ctx;
    }

    @Override
    public ReturnValueRestriction clone() {
        Declaration[] previous = new Declaration[this.previousDeclarations.length];
        for (int i = 0; i < previous.length; ++i) {
            previous[i] = this.previousDeclarations[i].clone();
        }
        Declaration[] local = new Declaration[this.localDeclarations.length];
        for (int i = 0; i < local.length; ++i) {
            local[i] = this.localDeclarations[i].clone();
        }
        ReturnValueRestriction clone = new ReturnValueRestriction(this.readAccessor, this.expression, previous, local, this.requiredGlobals, this.evaluator);
        if (this.cloned == Collections.EMPTY_LIST) {
            this.cloned = new ArrayList<ReturnValueRestriction>(1);
        }
        this.cloned.add(clone);
        return clone;
    }

    public static class ReturnValueContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public ReadAccessor fieldExtractor;
        public InternalFactHandle handle;
        public LeftTuple leftTuple;
        public InternalWorkingMemory workingMemory;
        public Declaration[] previousDeclarations;
        public Declaration[] localDeclarations;
        private ContextEntry entry;
        public Object dialectContext;

        public ReturnValueContextEntry() {
        }

        public ReturnValueContextEntry(ReadAccessor fieldExtractor, Declaration[] previousDeclarations, Declaration[] localDeclarations) {
            this.fieldExtractor = fieldExtractor;
            this.previousDeclarations = previousDeclarations;
            this.localDeclarations = localDeclarations;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.fieldExtractor = (ReadAccessor)in.readObject();
            this.handle = (InternalFactHandle)in.readObject();
            this.leftTuple = (LeftTuple)in.readObject();
            this.workingMemory = (InternalWorkingMemory)in.readObject();
            this.previousDeclarations = (Declaration[])in.readObject();
            this.localDeclarations = (Declaration[])in.readObject();
            this.entry = (ContextEntry)in.readObject();
            this.dialectContext = in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.fieldExtractor);
            out.writeObject(this.handle);
            out.writeObject(this.leftTuple);
            out.writeObject(this.workingMemory);
            out.writeObject(this.previousDeclarations);
            out.writeObject(this.localDeclarations);
            out.writeObject(this.entry);
            out.writeObject(this.dialectContext);
        }

        @Override
        public ContextEntry getNext() {
            return this.entry;
        }

        @Override
        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.handle = handle;
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.workingMemory = workingMemory;
            this.leftTuple = tuple;
        }

        public ReadAccessor getFieldExtractor() {
            return this.fieldExtractor;
        }

        public LeftTuple getTuple() {
            return this.leftTuple;
        }

        public InternalFactHandle getHandle() {
            return this.handle;
        }

        public Declaration[] getPreviousDeclarations() {
            return this.previousDeclarations;
        }

        public Declaration[] getLocalDeclarations() {
            return this.localDeclarations;
        }

        public InternalWorkingMemory getWorkingMemory() {
            return this.workingMemory;
        }

        @Override
        public void resetTuple() {
            this.leftTuple = null;
        }

        @Override
        public void resetFactHandle() {
            this.handle = null;
        }
    }
}

