/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.editpart.work;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.core.process.core.ParameterDefinition;
import org.drools.core.process.core.Work;
import org.drools.core.process.core.WorkDefinition;
import org.drools.core.process.core.WorkEditor;
import org.drools.core.process.core.impl.WorkImpl;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SampleCustomEditor
extends EditBeanDialog
implements WorkEditor {
    private WorkDefinition workDefinition;
    private Map<String, Text> texts = new HashMap<String, Text>();

    public SampleCustomEditor(Shell parentShell) {
        super(parentShell, "Custom Work Editor");
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Work work = (Work)this.getValue();
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name: ");
        Text nameText = new Text(composite, 0);
        nameText.setEditable(false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        nameText.setLayoutData((Object)gridData);
        String name = work.getName();
        nameText.setText(name == null ? "" : name);
        Set parameters = this.workDefinition.getParameters();
        for (ParameterDefinition param : parameters) {
            Label label = new Label(composite, 0);
            label.setText(String.valueOf(param.getName()) + ": ");
            Text text = new Text(composite, 0);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            text.setLayoutData((Object)gridData);
            this.texts.put(param.getName(), text);
            Object value = work.getParameter(param.getName());
            text.setText(value == null ? "" : value.toString());
        }
        return composite;
    }

    protected Object updateValue(Object value) {
        WorkImpl work = new WorkImpl();
        work.setName(((Work)value).getName());
        Iterator<Map.Entry<String, Text>> iterator = this.texts.entrySet().iterator();
        while (iterator.hasNext()) {
            String text;
            Map.Entry<String, Text> entry;
            work.setParameter(entry.getKey(), (Object)("".equals(text = (entry = iterator.next()).getValue().getText()) ? null : text));
        }
        work.setParameterDefinitions(((Work)value).getParameterDefinitions());
        return work;
    }

    public Work getWork() {
        return (Work)this.getValue();
    }

    public void setWork(Work work) {
        this.setValue(work);
    }

    public void setWorkDefinition(WorkDefinition workDefinition) {
        this.workDefinition = workDefinition;
    }

    public boolean show() {
        int result = this.open();
        return result == 0;
    }
}

