/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Collection;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaultNodeInstance
extends NodeInstanceImpl {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(FaultNodeInstance.class);

    protected FaultNode getFaultNode() {
        return (FaultNode)this.getNode();
    }

    @Override
    public void internalTrigger(org.kie.api.runtime.process.NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A FaultNode only accepts default incoming connections!");
        }
        String faultName = this.getFaultName();
        ExceptionScopeInstance exceptionScopeInstance = this.getExceptionScopeInstance(faultName);
        NodeInstanceContainer nodeInstanceContainer = (NodeInstanceContainer)this.getNodeInstanceContainer();
        nodeInstanceContainer.removeNodeInstance(this);
        boolean exceptionHandled = false;
        if (this.getFaultNode().isTerminateParent()) {
            if (exceptionScopeInstance != null) {
                exceptionHandled = true;
                this.handleException(faultName, exceptionScopeInstance);
            }
            if (nodeInstanceContainer instanceof CompositeNodeInstance) {
                ((CompositeNodeInstance)nodeInstanceContainer).cancel();
            } else if (nodeInstanceContainer instanceof WorkflowProcessInstance) {
                Collection nodeInstances = ((WorkflowProcessInstance)nodeInstanceContainer).getNodeInstances();
                for (org.kie.api.runtime.process.NodeInstance nodeInstance : nodeInstances) {
                    ((NodeInstance)nodeInstance).cancel();
                }
            }
        }
        if (exceptionScopeInstance != null) {
            if (!exceptionHandled) {
                this.handleException(faultName, exceptionScopeInstance);
            }
        } else {
            this.getProcessInstance().setState(3, faultName);
        }
    }

    protected ExceptionScopeInstance getExceptionScopeInstance(String faultName) {
        return (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", faultName);
    }

    protected String getFaultName() {
        return this.getFaultNode().getFaultName();
    }

    protected Object getFaultData() {
        Object value = null;
        String faultVariable = this.getFaultNode().getFaultVariable();
        if (faultVariable != null) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", faultVariable);
            if (variableScopeInstance != null) {
                value = variableScopeInstance.getVariable(faultVariable);
            } else {
                logger.error("Could not find variable scope for variable {}", (Object)faultVariable);
                logger.error("when trying to execute fault node {}", (Object)this.getFaultNode().getName());
                logger.error("Continuing without setting value.");
            }
        }
        return value;
    }

    protected void handleException(String faultName, ExceptionScopeInstance exceptionScopeInstance) {
        exceptionScopeInstance.handleException(faultName, this.getFaultData());
    }
}

