/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.strategy.PersistenceStrategy;
import org.jbpm.process.audit.strategy.PersistenceStrategyType;
import org.jbpm.process.audit.strategy.StandaloneJtaStrategy;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAAuditLogService
implements AuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(JPAAuditLogService.class);
    private PersistenceStrategy persistenceStrategy;
    private String persistenceUnitName = "org.jbpm.persistence.jpa";

    public JPAAuditLogService() {
        EntityManagerFactory emf = null;
        try {
            emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName);
        }
        catch (Exception e) {
            logger.info("The '" + this.persistenceUnitName + "' peristence unit is not available, no persistence strategy set for " + this.getClass().getSimpleName());
        }
        if (emf != null) {
            this.persistenceStrategy = new StandaloneJtaStrategy(emf);
        }
    }

    public JPAAuditLogService(Environment env, PersistenceStrategyType type) {
        this.persistenceStrategy = PersistenceStrategyType.getPersistenceStrategy(type, env);
    }

    public JPAAuditLogService(Environment env) {
        EntityManagerFactory emf = (EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        this.persistenceStrategy = emf != null ? new StandaloneJtaStrategy(emf) : new StandaloneJtaStrategy(Persistence.createEntityManagerFactory((String)this.persistenceUnitName));
    }

    public JPAAuditLogService(EntityManagerFactory emf) {
        this.persistenceStrategy = new StandaloneJtaStrategy(emf);
    }

    public JPAAuditLogService(EntityManagerFactory emf, PersistenceStrategyType type) {
        this.persistenceStrategy = PersistenceStrategyType.getPersistenceStrategy(type, emf);
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceStrategy = new StandaloneJtaStrategy(Persistence.createEntityManagerFactory((String)persistenceUnitName));
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    @Override
    public List<ProcessInstanceLog> findProcessInstances() {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        List result = em.createQuery("FROM ProcessInstanceLog").getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<ProcessInstanceLog> findProcessInstances(String processId) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        List result = em.createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId").setParameter("processId", (Object)processId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<ProcessInstanceLog> findActiveProcessInstances(String processId) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        List result = this.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.processId = :processId AND p.end is null").setParameter("processId", (Object)processId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessInstanceLog findProcessInstance(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        try {
            ProcessInstanceLog processInstanceLog = (ProcessInstanceLog)this.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.processInstanceId = :processInstanceId").setParameter("processInstanceId", (Object)processInstanceId).getSingleResult();
            return processInstanceLog;
        }
        catch (NoResultException e) {
            ProcessInstanceLog processInstanceLog = null;
            return processInstanceLog;
        }
        finally {
            this.closeEntityManager(em, newTx);
        }
    }

    @Override
    public List<ProcessInstanceLog> findSubProcessInstances(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        List result = this.getEntityManager().createQuery("FROM ProcessInstanceLog p WHERE p.parentProcessInstanceId = :processInstanceId").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<NodeInstanceLog> findNodeInstances(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        List result = this.getEntityManager().createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId ORDER BY date,id").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<NodeInstanceLog> findNodeInstances(long processInstanceId, String nodeId) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        List result = this.getEntityManager().createQuery("FROM NodeInstanceLog n WHERE n.processInstanceId = :processInstanceId AND n.nodeId = :nodeId ORDER BY date,id").setParameter("processInstanceId", (Object)processInstanceId).setParameter("nodeId", (Object)nodeId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<VariableInstanceLog> findVariableInstances(long processInstanceId) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        List result = this.getEntityManager().createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<VariableInstanceLog> findVariableInstances(long processInstanceId, String variableId) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        List result = em.createQuery("FROM VariableInstanceLog v WHERE v.processInstanceId = :processInstanceId AND v.variableId = :variableId ORDER BY date").setParameter("processInstanceId", (Object)processInstanceId).setParameter("variableId", (Object)variableId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<VariableInstanceLog> findVariableInstancesByName(String variableId, boolean onlyActiveProcesses) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        Query query = !onlyActiveProcesses ? em.createQuery("FROM VariableInstanceLog v WHERE v.variableId = :variableId ORDER BY date") : em.createQuery("SELECT v FROM VariableInstanceLog v, ProcessInstanceLog p WHERE v.processInstanceId = p.processInstanceId AND v.variableId = :variableId AND p.end is null ORDER BY v.date");
        List result = query.setParameter("variableId", (Object)variableId).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public List<VariableInstanceLog> findVariableInstancesByNameAndValue(String variableId, String value, boolean onlyActiveProcesses) {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        Query query = !onlyActiveProcesses ? em.createQuery("FROM VariableInstanceLog v WHERE v.variableId = :variableId AND v.value = :value ORDER BY date") : em.createQuery("SELECT v FROM VariableInstanceLog v, ProcessInstanceLog p WHERE v.processInstanceId = p.processInstanceId AND v.variableId = :variableId AND v.value = :value AND p.end is null ORDER BY v.date");
        List result = query.setParameter("variableId", (Object)variableId).setParameter("value", (Object)value).getResultList();
        this.closeEntityManager(em, newTx);
        return result;
    }

    @Override
    public void clear() {
        EntityManager em = this.getEntityManager();
        Object newTx = this.joinTransaction(em);
        List processInstances = em.createQuery("FROM ProcessInstanceLog").getResultList();
        for (ProcessInstanceLog processInstance : processInstances) {
            em.remove((Object)processInstance);
        }
        List nodeInstances = em.createQuery("FROM NodeInstanceLog").getResultList();
        for (NodeInstanceLog nodeInstance : nodeInstances) {
            em.remove((Object)nodeInstance);
        }
        List variableInstances = em.createQuery("FROM VariableInstanceLog").getResultList();
        for (VariableInstanceLog variableInstance : variableInstances) {
            em.remove((Object)variableInstance);
        }
        this.closeEntityManager(em, newTx);
    }

    @Override
    public void dispose() {
        this.persistenceStrategy.dispose();
    }

    private EntityManager getEntityManager() {
        return this.persistenceStrategy.getEntityManager();
    }

    private Object joinTransaction(EntityManager em) {
        return this.persistenceStrategy.joinTransaction(em);
    }

    private void closeEntityManager(EntityManager em, Object transaction) {
        this.persistenceStrategy.leaveTransaction(em, transaction);
    }
}

