/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.wizards;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.guvnor.tools.Activator;
import org.guvnor.tools.GuvnorRepository;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.views.RepositoryContentProvider;
import org.guvnor.tools.views.RepositoryLabelProvider;
import org.guvnor.tools.views.model.TreeObject;
import org.guvnor.tools.views.model.TreeParent;
import org.guvnor.tools.wizards.GuvWizardModel;
import org.guvnor.tools.wizards.IGuvnorWizard;
import org.guvnor.tools.wizards.WizardUtils;

public class SelectGuvnorFolderPage
extends WizardPage {
    private TreeViewer viewer;
    private String previousSelection;

    public SelectGuvnorFolderPage(String pageName) {
        super(pageName);
    }

    public SelectGuvnorFolderPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = PlatformUtils.createComposite(parent, 1);
        new Label(composite, 0).setText(Messages.getString("select.folder"));
        this.viewer = new TreeViewer(composite, 2820);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectGuvnorFolderPage.this.updateModel();
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof TreeObject) {
                    TreeObject o = (TreeObject)element;
                    return o.getFullPath().indexOf("/snapshots/") == -1;
                }
                return true;
            }
        });
        super.setControl((Control)composite);
    }

    private void handleRepositoryCreation() {
        GuvWizardModel model = ((IGuvnorWizard)super.getWizard()).getModel();
        if (model.shouldCreateNewRep() && model.getRepLocation() != null) {
            GuvnorRepository theRep = Activator.getLocationManager().findRepository(model.getRepLocation());
            if (theRep != null) {
                return;
            }
            try {
                WizardUtils.createGuvnorRepository(model);
            }
            catch (Exception e) {
                super.setErrorMessage(e.getMessage());
                Activator.getDefault().writeLog(4, e.getMessage(), e);
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            GuvWizardModel model = ((IGuvnorWizard)super.getWizard()).getModel();
            String currentSelection = model.getRepLocation();
            assert (currentSelection != null);
            if (this.previousSelection != null && !currentSelection.equals(this.previousSelection)) {
                this.handleRepositoryCreation();
                RepositoryContentProvider cp = new RepositoryContentProvider();
                cp.setRepositorySelection(currentSelection);
                this.viewer.setContentProvider((IContentProvider)cp);
                this.viewer.setInput((Object)this.viewer);
                this.previousSelection = currentSelection;
            } else if (this.previousSelection == null) {
                this.handleRepositoryCreation();
                RepositoryContentProvider cp = new RepositoryContentProvider();
                cp.setRepositorySelection(currentSelection);
                this.viewer.setContentProvider((IContentProvider)cp);
                this.viewer.setInput((Object)this.viewer);
                this.previousSelection = currentSelection;
            }
        }
        super.setVisible(visible);
    }

    private void updateModel() {
        if (super.getErrorMessage() != null) {
            super.setErrorMessage(null);
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        GuvWizardModel model = ((IGuvnorWizard)super.getWizard()).getModel();
        if (selection.getFirstElement() instanceof TreeParent) {
            TreeParent node = (TreeParent)selection.getFirstElement();
            if (node.getNodeType() != TreeObject.Type.NONE) {
                this.viewer.expandToLevel((Object)node, 1);
                String base = node.getFullPath().endsWith("/") ? node.getFullPath() : String.valueOf(node.getFullPath()) + "/";
                model.setTargetLocation(base);
                super.getWizard().getContainer().updateButtons();
            } else {
                model.setTargetLocation(null);
                super.getWizard().getContainer().updateButtons();
            }
        } else {
            model.setTargetLocation(null);
            super.getWizard().getContainer().updateButtons();
        }
    }
}

