/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.preferences;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DroolsFlowNodesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button ruleFlowGroupButton;
    private Button splitButton;
    private Button joinButton;
    private Button eventWaitButton;
    private Button subFlowButton;
    private Button actionButton;
    private Button timerButton;
    private Button faultButton;
    private Button eventButton;
    private Button humanTaskButton;
    private Button compositeButton;
    private Button forEachButton;
    private Button workItemsButton;

    public DroolsFlowNodesPreferencePage() {
        super("Drools Flow nodes");
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite ancestor) {
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ancestor.setLayout((Layout)layout);
        Label l = new Label(ancestor, 64);
        l.setFont(ancestor.getFont());
        l.setText("Select which nodes are shown in the Drools Flow editor");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 300;
        l.setLayoutData((Object)gd);
        l = new Label(ancestor, 0);
        gd = new GridData(768);
        gd.heightHint = 1;
        l.setLayoutData((Object)gd);
        Button startButton = this.createCheckBox(ancestor, "Start");
        startButton.setSelection(true);
        startButton.setEnabled(false);
        Button endButton = this.createCheckBox(ancestor, "End");
        endButton.setSelection(true);
        endButton.setEnabled(false);
        this.ruleFlowGroupButton = this.createCheckBox(ancestor, "RuleFlowGroup");
        this.splitButton = this.createCheckBox(ancestor, "Split");
        this.joinButton = this.createCheckBox(ancestor, "Join");
        this.eventWaitButton = this.createCheckBox(ancestor, "Event Wait");
        this.subFlowButton = this.createCheckBox(ancestor, "SubFlow");
        this.actionButton = this.createCheckBox(ancestor, "Action");
        this.timerButton = this.createCheckBox(ancestor, "Timer");
        this.faultButton = this.createCheckBox(ancestor, "Fault");
        this.eventButton = this.createCheckBox(ancestor, "Event");
        this.humanTaskButton = this.createCheckBox(ancestor, "HumanTask");
        this.compositeButton = this.createCheckBox(ancestor, "Composite");
        this.forEachButton = this.createCheckBox(ancestor, "ForEach");
        this.workItemsButton = this.createCheckBox(ancestor, "WorkItems");
        this.initializeValues();
        this.applyDialogFont(ancestor);
        return ancestor;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        return button;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return DroolsEclipsePlugin.getDefault().getPreferenceStore();
    }

    private void initializeDefaults() {
        this.initializeValues("1111111111111");
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        String flowNodes = store.getString("Drools.FlowNodes");
        if (flowNodes == null || flowNodes.length() != 13) {
            flowNodes = "1111111111111";
        }
        this.initializeValues(flowNodes);
    }

    private void initializeValues(String flowNodes) {
        this.ruleFlowGroupButton.setSelection(flowNodes.charAt(0) == '1');
        this.splitButton.setSelection(flowNodes.charAt(1) == '1');
        this.joinButton.setSelection(flowNodes.charAt(2) == '1');
        this.eventWaitButton.setSelection(flowNodes.charAt(3) == '1');
        this.subFlowButton.setSelection(flowNodes.charAt(4) == '1');
        this.actionButton.setSelection(flowNodes.charAt(5) == '1');
        this.timerButton.setSelection(flowNodes.charAt(6) == '1');
        this.faultButton.setSelection(flowNodes.charAt(7) == '1');
        this.eventButton.setSelection(flowNodes.charAt(8) == '1');
        this.humanTaskButton.setSelection(flowNodes.charAt(9) == '1');
        this.compositeButton.setSelection(flowNodes.charAt(10) == '1');
        this.forEachButton.setSelection(flowNodes.charAt(11) == '1');
        this.workItemsButton.setSelection(flowNodes.charAt(12) == '1');
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        DroolsEclipsePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        String flowNodes = "" + (this.ruleFlowGroupButton.getSelection() ? (char)'1' : '0') + (this.splitButton.getSelection() ? (char)'1' : '0') + (this.joinButton.getSelection() ? (char)'1' : '0') + (this.eventWaitButton.getSelection() ? (char)'1' : '0') + (this.subFlowButton.getSelection() ? (char)'1' : '0') + (this.actionButton.getSelection() ? (char)'1' : '0') + (this.timerButton.getSelection() ? (char)'1' : '0') + (this.faultButton.getSelection() ? (char)'1' : '0') + (this.eventButton.getSelection() ? (char)'1' : '0') + (this.humanTaskButton.getSelection() ? (char)'1' : '0') + (this.compositeButton.getSelection() ? (char)'1' : '0') + (this.forEachButton.getSelection() ? (char)'1' : '0') + (this.workItemsButton.getSelection() ? (char)'1' : '0');
        store.setValue("Drools.FlowNodes", flowNodes);
    }
}

