/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import org.drools.core.common.InternalAgenda;
import org.drools.core.spi.Activation;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.kie.api.definition.process.Connection;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;

public class StateNodeInstance
extends CompositeContextNodeInstance
implements EventListener {
    private static final long serialVersionUID = 510L;

    protected StateNode getStateNode() {
        return (StateNode)this.getNode();
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (this.getNodeInstanceContainer().getNodeInstance(this.getId()) == null) {
            return;
        }
        StateNode stateNode = this.getStateNode();
        Connection selected = null;
        int priority = Integer.MAX_VALUE;
        for (Connection connection : stateNode.getOutgoingConnections("DROOLS_DEFAULT")) {
            Constraint constraint = stateNode.getConstraint(connection);
            if (constraint == null || constraint.getPriority() >= priority) continue;
            String rule = "RuleFlowStateNode-" + this.getProcessInstance().getProcessId() + "-" + this.getStateNode().getUniqueId() + "-" + connection.getTo().getId() + "-" + connection.getToType();
            boolean isActive = ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).isRuleActiveInRuleFlowGroup("DROOLS_SYSTEM", rule, this.getProcessInstance().getId());
            if (!isActive) continue;
            selected = connection;
            priority = constraint.getPriority();
        }
        if (selected != null) {
            ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
            this.triggerConnection(selected);
        } else {
            this.addTriggerListener();
            this.addActivationListener();
        }
    }

    @Override
    protected boolean isLinkedIncomingNodeRequired() {
        return false;
    }

    @Override
    public void signalEvent(String type, Object event) {
        if ("signal".equals(type)) {
            if (event instanceof String) {
                for (Connection connection : this.getStateNode().getOutgoingConnections("DROOLS_DEFAULT")) {
                    boolean selected = false;
                    Constraint constraint = this.getStateNode().getConstraint(connection);
                    if (constraint == null) {
                        if (((String)event).equals(connection.getTo().getName())) {
                            selected = true;
                        }
                    } else if (((String)event).equals(constraint.getName())) {
                        selected = true;
                    }
                    if (!selected) continue;
                    this.triggerEvent("onExit");
                    this.removeEventListeners();
                    ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
                    this.triggerConnection(connection);
                    return;
                }
            }
        } else if (this.getActivationEventType().equals(type)) {
            if (event instanceof MatchCreatedEvent) {
                this.activationCreated((MatchCreatedEvent)event);
            }
        } else {
            super.signalEvent(type, event);
        }
    }

    private void addTriggerListener() {
        this.getProcessInstance().addEventListener("signal", this, false);
    }

    private void addActivationListener() {
        this.getProcessInstance().addEventListener(this.getActivationEventType(), this, true);
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addTriggerListener();
        this.addActivationListener();
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("signal", this, false);
        this.getProcessInstance().removeEventListener(this.getActivationEventType(), this, true);
    }

    @Override
    public String[] getEventTypes() {
        return new String[]{"signal", this.getActivationEventType()};
    }

    private String getActivationEventType() {
        return "RuleFlowStateNode-" + this.getProcessInstance().getProcessId() + "-" + this.getStateNode().getUniqueId();
    }

    public void activationCreated(MatchCreatedEvent event) {
        Connection selected = null;
        for (Connection connection : this.getNode().getOutgoingConnections("DROOLS_DEFAULT")) {
            String constraintName;
            Constraint constraint = this.getStateNode().getConstraint(connection);
            if (constraint == null || !(constraintName = this.getActivationEventType() + "-" + connection.getTo().getId() + "-" + connection.getToType()).equals(event.getMatch().getRule().getName()) || !this.checkProcessInstance((Activation)event.getMatch())) continue;
            selected = connection;
        }
        if (selected != null) {
            if (!this.getProcessInstance().getKnowledgeRuntime().getActionQueue().isEmpty()) {
                this.getProcessInstance().getKnowledgeRuntime().executeQueuedActions();
            }
            this.removeEventListeners();
            ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
            this.triggerConnection(selected);
        }
    }
}

