/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.drools.core.common.DisconnectedWorkingMemoryEntryPoint;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.factmodel.traits.TraitFactory;
import org.drools.core.factmodel.traits.TraitTypeEnum;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.StringUtils;
import org.kie.api.runtime.rule.EntryPoint;

@XmlRootElement(name="fact-handle")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultFactHandle
extends AbstractBaseLinkedListNode<DefaultFactHandle>
implements InternalFactHandle {
    private static final long serialVersionUID = 510L;
    private int id;
    private long recency;
    private Object object;
    private EqualityKey key;
    private int objectHashCode;
    private int identityHashCode;
    private RightTuple firstRightTuple;
    private RightTuple lastRightTuple;
    private LeftTuple firstLeftTuple;
    private LeftTuple lastLeftTuple;
    private EntryPoint entryPoint;
    private boolean disconnected;
    private TraitTypeEnum traitType;
    private boolean valid = true;

    public DefaultFactHandle() {
    }

    public DefaultFactHandle(int id, Object object) {
        this(id, object, id, null, false);
    }

    public DefaultFactHandle(int id, Object object, long recency, EntryPoint wmEntryPoint) {
        this(id, DefaultFactHandle.determineIdentityHashCode(object), object, recency, wmEntryPoint, false);
    }

    public DefaultFactHandle(int id, Object object, long recency, EntryPoint wmEntryPoint, boolean isTraitOrTraitable) {
        this(id, DefaultFactHandle.determineIdentityHashCode(object), object, recency, wmEntryPoint, isTraitOrTraitable);
    }

    public DefaultFactHandle(int id, int identityHashCode, Object object, long recency, EntryPoint wmEntryPoint, boolean isTraitOrTraitable) {
        this.id = id;
        this.entryPoint = wmEntryPoint;
        this.recency = recency;
        this.object = object;
        this.objectHashCode = object != null ? object.hashCode() : 0;
        this.identityHashCode = identityHashCode;
        this.traitType = isTraitOrTraitable ? this.determineTraitType() : TraitTypeEnum.NON_TRAIT;
    }

    public DefaultFactHandle(int id, String wmEntryPointId, int identityHashCode, int objectHashCode, long recency, Object object) {
        this.id = id;
        this.entryPoint = wmEntryPointId == null ? null : new DisconnectedWorkingMemoryEntryPoint(wmEntryPointId);
        this.identityHashCode = identityHashCode;
        this.objectHashCode = objectHashCode;
        this.recency = recency;
        this.object = object;
        this.disconnected = true;
        this.traitType = TraitTypeEnum.NON_TRAIT;
    }

    public DefaultFactHandle(String externalFormat) {
        this.createFromExternalFormat(externalFormat);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof DefaultFactHandle)) {
            return false;
        }
        return this.id == ((DefaultFactHandle)object).id;
    }

    @Override
    public void disconnect() {
        this.key = null;
        this.firstLeftTuple = null;
        this.firstRightTuple = null;
        this.lastLeftTuple = null;
        this.lastRightTuple = null;
        this.entryPoint = this.entryPoint == null ? null : new DisconnectedWorkingMemoryEntryPoint(this.entryPoint.getEntryPointId());
        this.disconnected = true;
    }

    @Override
    public boolean isDisconnected() {
        return this.disconnected;
    }

    @Override
    public int getObjectHashCode() {
        return this.objectHashCode;
    }

    @Override
    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public static int determineIdentityHashCode(Object object) {
        return System.identityHashCode(object);
    }

    protected void setObjectHashCode(int hashCode) {
        this.objectHashCode = hashCode;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public String toExternalForm() {
        return "0:" + this.id + ":" + this.getIdentityHashCode() + ":" + this.getObjectHashCode() + ":" + this.getRecency() + ":" + (this.entryPoint != null ? this.entryPoint.getEntryPointId() : "null") + ":" + this.traitType.name();
    }

    @XmlAttribute(name="external-form")
    public String getExternalForm() {
        return this.toExternalForm();
    }

    public void setExternalForm(String externalForm) {
        this.createFromExternalFormat(externalForm);
    }

    public String toString() {
        return "[fact " + this.toExternalForm() + ":" + this.object + "]";
    }

    @Override
    public long getRecency() {
        return this.recency;
    }

    @Override
    public void setRecency(long recency) {
        this.recency = recency;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public void setObject(Object object) {
        this.object = object;
        int n = this.objectHashCode = object != null ? object.hashCode() : 0;
        if (this.isTraitOrTraitable()) {
            TraitTypeEnum newType = this.determineTraitType();
            if (this.traitType != TraitTypeEnum.LEGACY_TRAITABLE || newType == TraitTypeEnum.LEGACY_TRAITABLE) {
                this.identityHashCode = DefaultFactHandle.determineIdentityHashCode(object);
            }
            this.traitType = newType;
        } else {
            this.identityHashCode = DefaultFactHandle.determineIdentityHashCode(object);
        }
    }

    @Override
    public EqualityKey getEqualityKey() {
        return this.key;
    }

    @Override
    public void setEqualityKey(EqualityKey key) {
        this.key = key;
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public boolean isTraitOrTraitable() {
        return this.traitType != TraitTypeEnum.NON_TRAIT;
    }

    @Override
    public RightTuple getFirstRightTuple() {
        return this.firstRightTuple;
    }

    protected void setFirstRightTuple(RightTuple firstRightTuple) {
        this.firstRightTuple = firstRightTuple;
    }

    @Override
    public RightTuple getLastRightTuple() {
        return this.lastRightTuple;
    }

    protected void setLastRightTuple(RightTuple lastRightTuple) {
        this.lastRightTuple = lastRightTuple;
    }

    @Override
    public void setFirstLeftTuple(LeftTuple firstLeftTuple) {
        this.firstLeftTuple = firstLeftTuple;
    }

    @Override
    public LeftTuple getFirstLeftTuple() {
        return this.firstLeftTuple;
    }

    @Override
    public void setLastLeftTuple(LeftTuple lastLeftTuple) {
        this.lastLeftTuple = lastLeftTuple;
    }

    @Override
    public LeftTuple getLastLeftTuple() {
        return this.lastLeftTuple;
    }

    @Override
    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public void setEntryPoint(EntryPoint sourceNode) {
        this.entryPoint = sourceNode;
    }

    @Override
    public void addFirstLeftTuple(LeftTuple leftTuple) {
        LeftTuple previous = this.getFirstLeftTuple();
        if (previous == null) {
            leftTuple.setLeftParentPrevious(null);
            leftTuple.setLeftParentNext(null);
            this.setFirstLeftTuple(leftTuple);
            this.setLastLeftTuple(leftTuple);
        } else {
            leftTuple.setLeftParentPrevious(null);
            leftTuple.setLeftParentNext(previous);
            previous.setLeftParentPrevious(leftTuple);
            this.setFirstLeftTuple(leftTuple);
        }
    }

    @Override
    public void addLastLeftTuple(LeftTuple leftTuple) {
        LeftTuple previous = this.getLastLeftTuple();
        if (previous == null) {
            leftTuple.setLeftParentPrevious(null);
            leftTuple.setLeftParentNext(null);
            this.setFirstLeftTuple(leftTuple);
            this.setLastLeftTuple(leftTuple);
        } else {
            leftTuple.setLeftParentPrevious(previous);
            leftTuple.setLeftParentNext(null);
            previous.setLeftParentNext(leftTuple);
            this.setLastLeftTuple(leftTuple);
        }
    }

    @Override
    public void addLeftTupleInPosition(LeftTuple leftTuple) {
        ObjectTypeNode.Id otnId;
        ObjectTypeNode.Id id = otnId = leftTuple.getLeftTupleSink() == null ? null : leftTuple.getLeftTupleSink().getLeftInputOtnId();
        if (otnId == null) {
            this.addLastLeftTuple(leftTuple);
            return;
        }
        LeftTuple previous = this.getLastLeftTuple();
        if (previous == null) {
            leftTuple.setLeftParentPrevious(null);
            leftTuple.setLeftParentNext(null);
            this.setFirstLeftTuple(leftTuple);
            this.setLastLeftTuple(leftTuple);
            return;
        }
        if (previous.getLeftTupleSink() == null || !otnId.before(previous.getLeftTupleSink().getLeftInputOtnId())) {
            leftTuple.setLeftParentPrevious(previous);
            leftTuple.setLeftParentNext(null);
            previous.setLeftParentNext(leftTuple);
            this.setLastLeftTuple(leftTuple);
            return;
        }
        LeftTuple next = previous;
        for (previous = previous.getLeftParentPrevious(); previous != null && otnId.before(previous.getLeftTupleSink().getLeftInputOtnId()); previous = previous.getLeftParentPrevious()) {
            next = previous;
        }
        leftTuple.setLeftParentNext(next);
        next.setLeftParentPrevious(leftTuple);
        leftTuple.setLeftParentPrevious(previous);
        if (previous != null) {
            previous.setLeftParentNext(leftTuple);
        } else {
            this.setFirstLeftTuple(leftTuple);
        }
    }

    @Override
    public void removeLeftTuple(LeftTuple leftTuple) {
        LeftTuple previous = leftTuple.getLeftParentPrevious();
        LeftTuple next = leftTuple.getLeftParentNext();
        if (previous != null && next != null) {
            previous.setLeftParentNext(next);
            next.setLeftParentPrevious(previous);
        } else if (next != null) {
            next.setLeftParentPrevious(null);
            this.setFirstLeftTuple(next);
        } else if (previous != null) {
            previous.setLeftParentNext(null);
            this.setLastLeftTuple(previous);
        } else {
            this.setFirstLeftTuple(null);
            this.setLastLeftTuple(null);
        }
        leftTuple.setLeftParentPrevious(null);
        leftTuple.setLeftParentNext(null);
    }

    @Override
    public void addFirstRightTuple(RightTuple rightTuple) {
        RightTuple previousFirst = this.getFirstRightTuple();
        this.setFirstRightTuple(rightTuple);
        if (previousFirst == null) {
            rightTuple.setHandlePrevious(null);
            rightTuple.setHandleNext(null);
            this.setLastRightTuple(rightTuple);
        } else {
            rightTuple.setHandlePrevious(null);
            rightTuple.setHandleNext(previousFirst);
            previousFirst.setHandlePrevious(rightTuple);
        }
    }

    @Override
    public void addLastRightTuple(RightTuple rightTuple) {
        RightTuple previousLast = this.getLastRightTuple();
        if (previousLast == null) {
            rightTuple.setHandlePrevious(null);
            rightTuple.setHandleNext(null);
            this.setFirstRightTuple(rightTuple);
            this.setLastRightTuple(rightTuple);
        } else {
            rightTuple.setHandlePrevious(previousLast);
            rightTuple.setHandleNext(null);
            previousLast.setHandleNext(rightTuple);
            this.setLastRightTuple(rightTuple);
        }
    }

    @Override
    public void addRightTupleInPosition(RightTuple rightTuple) {
        ObjectTypeNode.Id otnId;
        ObjectTypeNode.Id id = otnId = rightTuple.getRightTupleSink() == null ? null : rightTuple.getRightTupleSink().getRightInputOtnId();
        if (otnId == null) {
            this.addLastRightTuple(rightTuple);
            return;
        }
        RightTuple previous = this.getLastRightTuple();
        if (previous == null) {
            rightTuple.setHandlePrevious(null);
            rightTuple.setHandleNext(null);
            this.setFirstRightTuple(rightTuple);
            this.setLastRightTuple(rightTuple);
            return;
        }
        if (previous.getRightTupleSink() == null || !otnId.before(previous.getRightTupleSink().getRightInputOtnId())) {
            rightTuple.setHandlePrevious(previous);
            rightTuple.setHandleNext(null);
            previous.setHandleNext(rightTuple);
            this.setLastRightTuple(rightTuple);
            return;
        }
        RightTuple next = previous;
        for (previous = previous.getHandlePrevious(); previous != null && otnId.before(previous.getRightTupleSink().getRightInputOtnId()); previous = previous.getHandlePrevious()) {
            next = previous;
        }
        rightTuple.setHandleNext(next);
        next.setHandlePrevious(rightTuple);
        rightTuple.setHandlePrevious(previous);
        if (previous != null) {
            previous.setHandleNext(rightTuple);
        } else {
            this.setFirstRightTuple(rightTuple);
        }
    }

    @Override
    public void removeRightTuple(RightTuple rightTuple) {
        RightTuple previous = rightTuple.getHandlePrevious();
        RightTuple next = rightTuple.getHandleNext();
        if (previous != null && next != null) {
            previous.setHandleNext(next);
            next.setHandlePrevious(previous);
        } else if (next != null) {
            next.setHandlePrevious(null);
            this.setFirstRightTuple(next);
        } else if (previous != null) {
            previous.setHandleNext(null);
            this.setLastRightTuple(previous);
        } else {
            this.setFirstRightTuple(null);
            this.setLastRightTuple(null);
        }
        rightTuple.setHandlePrevious(null);
        rightTuple.setHandleNext(null);
    }

    @Override
    public void clearLeftTuples() {
        this.setFirstLeftTuple(null);
        this.setLastLeftTuple(null);
    }

    @Override
    public void clearRightTuples() {
        this.setFirstRightTuple(null);
        this.setLastRightTuple(null);
    }

    @Override
    public DefaultFactHandle quickClone() {
        DefaultFactHandle clone = new DefaultFactHandle(this.id, this.object, this.recency, this.entryPoint);
        clone.key = this.key;
        clone.objectHashCode = this.objectHashCode;
        clone.identityHashCode = this.identityHashCode;
        clone.disconnected = this.disconnected;
        clone.traitType = this.traitType;
        return clone;
    }

    public void quickCloneUpdate(DefaultFactHandle clone) {
        clone.object = this.object;
        clone.recency = this.recency;
        clone.key = this.key;
        clone.objectHashCode = this.objectHashCode;
        clone.identityHashCode = this.identityHashCode;
        clone.traitType = this.traitType;
        clone.disconnected = this.disconnected;
    }

    @Override
    public DefaultFactHandle clone() {
        DefaultFactHandle clone = new DefaultFactHandle(this.id, this.object, this.recency, this.entryPoint);
        clone.key = this.key;
        clone.firstLeftTuple = this.firstLeftTuple;
        clone.lastLeftTuple = this.lastLeftTuple;
        clone.firstRightTuple = this.firstRightTuple;
        clone.lastRightTuple = this.lastRightTuple;
        clone.objectHashCode = this.objectHashCode;
        clone.identityHashCode = System.identityHashCode(clone.object);
        clone.disconnected = this.disconnected;
        clone.traitType = this.traitType;
        return clone;
    }

    @Override
    public String toTupleTree(int indent) {
        StringBuilder buf = new StringBuilder();
        char[] spaces = new char[indent];
        Arrays.fill(spaces, ' ');
        String istr = new String(spaces);
        buf.append(istr);
        buf.append(this.toExternalString());
        buf.append("\n");
        for (LeftTuple leftTuple = this.firstLeftTuple; leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
            buf.append(leftTuple.toTupleTree(indent + 4));
        }
        return buf.toString();
    }

    private Object toExternalString() {
        return "[F:" + this.getId() + " first=" + System.identityHashCode(this.firstLeftTuple) + " last=" + System.identityHashCode(this.lastLeftTuple) + " ]";
    }

    private void createFromExternalFormat(String externalFormat) {
        String[] elements = externalFormat.split(":");
        if (elements.length < 6) {
            throw new IllegalArgumentException("externalFormat did not have enough elements [" + externalFormat + "]");
        }
        this.id = Integer.parseInt(elements[1]);
        this.identityHashCode = Integer.parseInt(elements[2]);
        this.objectHashCode = Integer.parseInt(elements[3]);
        this.recency = Long.parseLong(elements[4]);
        this.entryPoint = StringUtils.isEmpty(elements[5]) || "null".equals(elements[5].trim()) ? null : new DisconnectedWorkingMemoryEntryPoint(elements[5].trim());
        this.disconnected = true;
        this.traitType = elements.length > 6 ? TraitTypeEnum.valueOf(elements[6]) : TraitTypeEnum.NON_TRAIT;
    }

    private TraitTypeEnum determineTraitType() {
        if (this.isTraitOrTraitable()) {
            return TraitFactory.determineTraitType(this.object);
        }
        return TraitTypeEnum.NON_TRAIT;
    }

    @Override
    public boolean isTraitable() {
        return this.traitType == TraitTypeEnum.TRAITABLE || this.traitType == TraitTypeEnum.WRAPPED_TRAITABLE;
    }

    @Override
    public boolean isTraiting() {
        return this.traitType == TraitTypeEnum.TRAIT;
    }

    @Override
    public TraitTypeEnum getTraitType() {
        return this.traitType;
    }
}

